/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch.transform.PivotGroupBy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Pivot
implements JsonpSerializable {
    @Nullable
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Map<String, PivotGroupBy> groupBy;
    @Nullable
    private final Integer maxPageSearchSize;
    public static final JsonpDeserializer<Pivot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pivot::setupPivotDeserializer, Builder::build);

    public Pivot(Builder builder) {
        this.aggregations = ModelTypeHelper.unmodifiable(builder.aggregations);
        this.groupBy = ModelTypeHelper.unmodifiable(builder.groupBy);
        this.maxPageSearchSize = builder.maxPageSearchSize;
    }

    public Pivot(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public Map<String, PivotGroupBy> groupBy() {
        return this.groupBy;
    }

    @Nullable
    public Integer maxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Aggregation)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.groupBy != null) {
            generator.writeKey("group_by");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.groupBy.entrySet()) {
                generator.writeKey(entry.getKey());
                ((PivotGroupBy)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxPageSearchSize != null) {
            generator.writeKey("max_page_search_size");
            generator.write(this.maxPageSearchSize.intValue());
        }
    }

    protected static void setupPivotDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::groupBy, JsonpDeserializer.stringMapDeserializer(PivotGroupBy._DESERIALIZER), "group_by", new String[0]);
        op.add(Builder::maxPageSearchSize, JsonpDeserializer.integerDeserializer(), "max_page_search_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Pivot> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Map<String, PivotGroupBy> groupBy;
        @Nullable
        private Integer maxPageSearchSize;

        public Builder aggregations(@Nullable Map<String, Aggregation> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, Aggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, Aggregation>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder groupBy(@Nullable Map<String, PivotGroupBy> value) {
            this.groupBy = value;
            return this;
        }

        public Builder putGroupBy(String key, PivotGroupBy value) {
            if (this.groupBy == null) {
                this.groupBy = new HashMap<String, PivotGroupBy>();
            }
            this.groupBy.put(key, value);
            return this;
        }

        public Builder groupBy(String key, Function<PivotGroupBy.Builder, ObjectBuilder<PivotGroupBy>> fn) {
            return this.groupBy(Collections.singletonMap(key, fn.apply(new PivotGroupBy.Builder()).build()));
        }

        public Builder putGroupBy(String key, Function<PivotGroupBy.Builder, ObjectBuilder<PivotGroupBy>> fn) {
            return this.putGroupBy(key, fn.apply(new PivotGroupBy.Builder()).build());
        }

        public Builder maxPageSearchSize(@Nullable Integer value) {
            this.maxPageSearchSize = value;
            return this;
        }

        @Override
        public Pivot build() {
            return new Pivot(this);
        }
    }
}

