/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure.find_structure;

import co.elastic.clients.elasticsearch.text_structure.find_structure.TopHit;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldStat
implements JsonpSerializable {
    private final int count;
    private final int cardinality;
    private final List<TopHit> topHits;
    @Nullable
    private final Integer meanValue;
    @Nullable
    private final Integer medianValue;
    @Nullable
    private final Integer maxValue;
    @Nullable
    private final Integer minValue;
    @Nullable
    private final String earliest;
    @Nullable
    private final String latest;
    public static final JsonpDeserializer<FieldStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldStat::setupFieldStatDeserializer, Builder::build);

    public FieldStat(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.cardinality = Objects.requireNonNull(builder.cardinality, "cardinality");
        this.topHits = ModelTypeHelper.unmodifiableNonNull(builder.topHits, "top_hits");
        this.meanValue = builder.meanValue;
        this.medianValue = builder.medianValue;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
        this.earliest = builder.earliest;
        this.latest = builder.latest;
    }

    public FieldStat(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public List<TopHit> topHits() {
        return this.topHits;
    }

    @Nullable
    public Integer meanValue() {
        return this.meanValue;
    }

    @Nullable
    public Integer medianValue() {
        return this.medianValue;
    }

    @Nullable
    public Integer maxValue() {
        return this.maxValue;
    }

    @Nullable
    public Integer minValue() {
        return this.minValue;
    }

    @Nullable
    public String earliest() {
        return this.earliest;
    }

    @Nullable
    public String latest() {
        return this.latest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("cardinality");
        generator.write(this.cardinality);
        generator.writeKey("top_hits");
        generator.writeStartArray();
        for (TopHit item0 : this.topHits) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.meanValue != null) {
            generator.writeKey("mean_value");
            generator.write(this.meanValue.intValue());
        }
        if (this.medianValue != null) {
            generator.writeKey("median_value");
            generator.write(this.medianValue.intValue());
        }
        if (this.maxValue != null) {
            generator.writeKey("max_value");
            generator.write(this.maxValue.intValue());
        }
        if (this.minValue != null) {
            generator.writeKey("min_value");
            generator.write(this.minValue.intValue());
        }
        if (this.earliest != null) {
            generator.writeKey("earliest");
            generator.write(this.earliest);
        }
        if (this.latest != null) {
            generator.writeKey("latest");
            generator.write(this.latest);
        }
    }

    protected static void setupFieldStatDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::cardinality, JsonpDeserializer.integerDeserializer(), "cardinality", new String[0]);
        op.add(Builder::topHits, JsonpDeserializer.arrayDeserializer(TopHit._DESERIALIZER), "top_hits", new String[0]);
        op.add(Builder::meanValue, JsonpDeserializer.integerDeserializer(), "mean_value", new String[0]);
        op.add(Builder::medianValue, JsonpDeserializer.integerDeserializer(), "median_value", new String[0]);
        op.add(Builder::maxValue, JsonpDeserializer.integerDeserializer(), "max_value", new String[0]);
        op.add(Builder::minValue, JsonpDeserializer.integerDeserializer(), "min_value", new String[0]);
        op.add(Builder::earliest, JsonpDeserializer.stringDeserializer(), "earliest", new String[0]);
        op.add(Builder::latest, JsonpDeserializer.stringDeserializer(), "latest", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldStat> {
        private Integer count;
        private Integer cardinality;
        private List<TopHit> topHits;
        @Nullable
        private Integer meanValue;
        @Nullable
        private Integer medianValue;
        @Nullable
        private Integer maxValue;
        @Nullable
        private Integer minValue;
        @Nullable
        private String earliest;
        @Nullable
        private String latest;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder cardinality(int value) {
            this.cardinality = value;
            return this;
        }

        public Builder topHits(List<TopHit> value) {
            this.topHits = value;
            return this;
        }

        public Builder topHits(TopHit ... value) {
            this.topHits = Arrays.asList(value);
            return this;
        }

        public Builder addTopHits(TopHit value) {
            if (this.topHits == null) {
                this.topHits = new ArrayList<TopHit>();
            }
            this.topHits.add(value);
            return this;
        }

        public Builder topHits(Function<TopHit.Builder, ObjectBuilder<TopHit>> fn) {
            return this.topHits(fn.apply(new TopHit.Builder()).build());
        }

        public Builder addTopHits(Function<TopHit.Builder, ObjectBuilder<TopHit>> fn) {
            return this.addTopHits(fn.apply(new TopHit.Builder()).build());
        }

        public Builder meanValue(@Nullable Integer value) {
            this.meanValue = value;
            return this;
        }

        public Builder medianValue(@Nullable Integer value) {
            this.medianValue = value;
            return this;
        }

        public Builder maxValue(@Nullable Integer value) {
            this.maxValue = value;
            return this;
        }

        public Builder minValue(@Nullable Integer value) {
            this.minValue = value;
            return this;
        }

        public Builder earliest(@Nullable String value) {
            this.earliest = value;
            return this;
        }

        public Builder latest(@Nullable String value) {
            this.latest = value;
            return this;
        }

        @Override
        public FieldStat build() {
            return new FieldStat(this);
        }
    }
}

