/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.BaseNode;
import co.elastic.clients.elasticsearch.tasks.State;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class TaskExecutingNode
extends BaseNode {
    private final Map<String, State> tasks;
    public static final JsonpDeserializer<TaskExecutingNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskExecutingNode::setupTaskExecutingNodeDeserializer, Builder::build);

    public TaskExecutingNode(Builder builder) {
        super(builder);
        this.tasks = ModelTypeHelper.unmodifiableNonNull(builder.tasks, "tasks");
    }

    public TaskExecutingNode(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, State> tasks() {
        return this.tasks;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("tasks");
        generator.writeStartObject();
        for (Map.Entry<String, State> item0 : this.tasks.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTaskExecutingNodeDeserializer(DelegatingDeserializer<Builder> op) {
        BaseNode.setupBaseNodeDeserializer(op);
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(State._DESERIALIZER), "tasks", new String[0]);
    }

    public static class Builder
    extends BaseNode.AbstractBuilder<Builder>
    implements ObjectBuilder<TaskExecutingNode> {
        private Map<String, State> tasks;

        public Builder tasks(Map<String, State> value) {
            this.tasks = value;
            return this;
        }

        public Builder putTasks(String key, State value) {
            if (this.tasks == null) {
                this.tasks = new HashMap<String, State>();
            }
            this.tasks.put(key, value);
            return this;
        }

        public Builder tasks(String key, Function<State.Builder, ObjectBuilder<State>> fn) {
            return this.tasks(Collections.singletonMap(key, fn.apply(new State.Builder()).build()));
        }

        public Builder putTasks(String key, Function<State.Builder, ObjectBuilder<State>> fn) {
            return this.putTasks(key, fn.apply(new State.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TaskExecutingNode build() {
            return new TaskExecutingNode(this);
        }
    }
}

