/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Status
implements JsonpSerializable {
    private final long batches;
    @Nullable
    private final String canceled;
    private final long created;
    private final long deleted;
    private final long noops;
    @Nullable
    private final List<String> failures;
    private final float requestsPerSecond;
    private final Retries retries;
    @Nullable
    private final String throttled;
    private final long throttledMillis;
    @Nullable
    private final String throttledUntil;
    private final long throttledUntilMillis;
    @Nullable
    private final Boolean timedOut;
    @Nullable
    private final Long took;
    private final long total;
    private final long updated;
    private final long versionConflicts;
    public static final JsonpDeserializer<Status> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Status::setupStatusDeserializer, Builder::build);

    public Status(Builder builder) {
        this.batches = Objects.requireNonNull(builder.batches, "batches");
        this.canceled = builder.canceled;
        this.created = Objects.requireNonNull(builder.created, "created");
        this.deleted = Objects.requireNonNull(builder.deleted, "deleted");
        this.noops = Objects.requireNonNull(builder.noops, "noops");
        this.failures = ModelTypeHelper.unmodifiable(builder.failures);
        this.requestsPerSecond = Objects.requireNonNull(builder.requestsPerSecond, "requests_per_second").floatValue();
        this.retries = Objects.requireNonNull(builder.retries, "retries");
        this.throttled = builder.throttled;
        this.throttledMillis = Objects.requireNonNull(builder.throttledMillis, "throttled_millis");
        this.throttledUntil = builder.throttledUntil;
        this.throttledUntilMillis = Objects.requireNonNull(builder.throttledUntilMillis, "throttled_until_millis");
        this.timedOut = builder.timedOut;
        this.took = builder.took;
        this.total = Objects.requireNonNull(builder.total, "total");
        this.updated = Objects.requireNonNull(builder.updated, "updated");
        this.versionConflicts = Objects.requireNonNull(builder.versionConflicts, "version_conflicts");
    }

    public Status(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long batches() {
        return this.batches;
    }

    @Nullable
    public String canceled() {
        return this.canceled;
    }

    public long created() {
        return this.created;
    }

    public long deleted() {
        return this.deleted;
    }

    public long noops() {
        return this.noops;
    }

    @Nullable
    public List<String> failures() {
        return this.failures;
    }

    public float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public Retries retries() {
        return this.retries;
    }

    @Nullable
    public String throttled() {
        return this.throttled;
    }

    public long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public String throttledUntil() {
        return this.throttledUntil;
    }

    public long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public Boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public Long took() {
        return this.took;
    }

    public long total() {
        return this.total;
    }

    public long updated() {
        return this.updated;
    }

    public long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("batches");
        generator.write(this.batches);
        if (this.canceled != null) {
            generator.writeKey("canceled");
            generator.write(this.canceled);
        }
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (String item0 : this.failures) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("requests_per_second");
        generator.write((double)this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        if (this.throttled != null) {
            generator.writeKey("throttled");
            generator.write(this.throttled);
        }
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        if (this.throttledUntil != null) {
            generator.writeKey("throttled_until");
            generator.write(this.throttledUntil);
        }
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("updated");
        generator.write(this.updated);
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
    }

    protected static void setupStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches", new String[0]);
        op.add(Builder::canceled, JsonpDeserializer.stringDeserializer(), "canceled", new String[0]);
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created", new String[0]);
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted", new String[0]);
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "failures", new String[0]);
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second", new String[0]);
        op.add(Builder::retries, Retries._DESERIALIZER, "retries", new String[0]);
        op.add(Builder::throttled, JsonpDeserializer.stringDeserializer(), "throttled", new String[0]);
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis", new String[0]);
        op.add(Builder::throttledUntil, JsonpDeserializer.stringDeserializer(), "throttled_until", new String[0]);
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated", new String[0]);
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Status> {
        private Long batches;
        @Nullable
        private String canceled;
        private Long created;
        private Long deleted;
        private Long noops;
        @Nullable
        private List<String> failures;
        private Float requestsPerSecond;
        private Retries retries;
        @Nullable
        private String throttled;
        private Long throttledMillis;
        @Nullable
        private String throttledUntil;
        private Long throttledUntilMillis;
        @Nullable
        private Boolean timedOut;
        @Nullable
        private Long took;
        private Long total;
        private Long updated;
        private Long versionConflicts;

        public Builder batches(long value) {
            this.batches = value;
            return this;
        }

        public Builder canceled(@Nullable String value) {
            this.canceled = value;
            return this;
        }

        public Builder created(long value) {
            this.created = value;
            return this;
        }

        public Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        public Builder noops(long value) {
            this.noops = value;
            return this;
        }

        public Builder failures(@Nullable List<String> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(String ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(String value) {
            if (this.failures == null) {
                this.failures = new ArrayList<String>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        public Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        public Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public Builder throttled(@Nullable String value) {
            this.throttled = value;
            return this;
        }

        public Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        public Builder throttledUntil(@Nullable String value) {
            this.throttledUntil = value;
            return this;
        }

        public Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public Builder timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder updated(long value) {
            this.updated = value;
            return this;
        }

        public Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public Status build() {
            return new Status(this);
        }
    }
}

