/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStatsSummaryItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardsStatsSummary
implements JsonpSerializable {
    private final ShardsStatsSummaryItem incremental;
    private final ShardsStatsSummaryItem total;
    private final long startTimeInMillis;
    private final long timeInMillis;
    public static final JsonpDeserializer<ShardsStatsSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStatsSummary::setupShardsStatsSummaryDeserializer, Builder::build);

    public ShardsStatsSummary(Builder builder) {
        this.incremental = Objects.requireNonNull(builder.incremental, "incremental");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.timeInMillis = Objects.requireNonNull(builder.timeInMillis, "time_in_millis");
    }

    public ShardsStatsSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardsStatsSummaryItem incremental() {
        return this.incremental;
    }

    public ShardsStatsSummaryItem total() {
        return this.total;
    }

    public long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("incremental");
        this.incremental.serialize(generator, mapper);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    protected static void setupShardsStatsSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::incremental, ShardsStatsSummaryItem._DESERIALIZER, "incremental", new String[0]);
        op.add(Builder::total, ShardsStatsSummaryItem._DESERIALIZER, "total", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardsStatsSummary> {
        private ShardsStatsSummaryItem incremental;
        private ShardsStatsSummaryItem total;
        private Long startTimeInMillis;
        private Long timeInMillis;

        public Builder incremental(ShardsStatsSummaryItem value) {
            this.incremental = value;
            return this;
        }

        public Builder incremental(Function<ShardsStatsSummaryItem.Builder, ObjectBuilder<ShardsStatsSummaryItem>> fn) {
            return this.incremental(fn.apply(new ShardsStatsSummaryItem.Builder()).build());
        }

        public Builder total(ShardsStatsSummaryItem value) {
            this.total = value;
            return this;
        }

        public Builder total(Function<ShardsStatsSummaryItem.Builder, ObjectBuilder<ShardsStatsSummaryItem>> fn) {
            return this.total(fn.apply(new ShardsStatsSummaryItem.Builder()).build());
        }

        public Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        public ShardsStatsSummary build() {
            return new ShardsStatsSummary(this);
        }
    }
}

