/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexDetails
implements JsonpSerializable {
    private final int shardCount;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    private final long maxSegmentsPerShard;
    public static final JsonpDeserializer<IndexDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexDetails::setupIndexDetailsDeserializer, Builder::build);

    public IndexDetails(Builder builder) {
        this.shardCount = Objects.requireNonNull(builder.shardCount, "shard_count");
        this.size = builder.size;
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
        this.maxSegmentsPerShard = Objects.requireNonNull(builder.maxSegmentsPerShard, "max_segments_per_shard");
    }

    public IndexDetails(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int shardCount() {
        return this.shardCount;
    }

    @Nullable
    public String size() {
        return this.size;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long maxSegmentsPerShard() {
        return this.maxSegmentsPerShard;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shard_count");
        generator.write(this.shardCount);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("max_segments_per_shard");
        generator.write(this.maxSegmentsPerShard);
    }

    protected static void setupIndexDetailsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shardCount, JsonpDeserializer.integerDeserializer(), "shard_count", new String[0]);
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes", new String[0]);
        op.add(Builder::maxSegmentsPerShard, JsonpDeserializer.longDeserializer(), "max_segments_per_shard", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexDetails> {
        private Integer shardCount;
        @Nullable
        private String size;
        private Long sizeInBytes;
        private Long maxSegmentsPerShard;

        public Builder shardCount(int value) {
            this.shardCount = value;
            return this;
        }

        public Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public Builder maxSegmentsPerShard(long value) {
            this.maxSegmentsPerShard = value;
            return this;
        }

        @Override
        public IndexDetails build() {
            return new IndexDetails(this);
        }
    }
}

