/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch.slm.InProgress;
import co.elastic.clients.elasticsearch.slm.Invocation;
import co.elastic.clients.elasticsearch.slm.Policy;
import co.elastic.clients.elasticsearch.slm.Statistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SnapshotLifecycle
implements JsonpSerializable {
    @Nullable
    private final InProgress inProgress;
    @Nullable
    private final Invocation lastFailure;
    @Nullable
    private final Invocation lastSuccess;
    @Nullable
    private final String modifiedDate;
    private final String modifiedDateMillis;
    @Nullable
    private final String nextExecution;
    private final String nextExecutionMillis;
    private final Policy policy;
    private final long version;
    private final Statistics stats;
    public static final JsonpDeserializer<SnapshotLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotLifecycle::setupSnapshotLifecycleDeserializer, Builder::build);

    public SnapshotLifecycle(Builder builder) {
        this.inProgress = builder.inProgress;
        this.lastFailure = builder.lastFailure;
        this.lastSuccess = builder.lastSuccess;
        this.modifiedDate = builder.modifiedDate;
        this.modifiedDateMillis = Objects.requireNonNull(builder.modifiedDateMillis, "modified_date_millis");
        this.nextExecution = builder.nextExecution;
        this.nextExecutionMillis = Objects.requireNonNull(builder.nextExecutionMillis, "next_execution_millis");
        this.policy = Objects.requireNonNull(builder.policy, "policy");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
    }

    public SnapshotLifecycle(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public InProgress inProgress() {
        return this.inProgress;
    }

    @Nullable
    public Invocation lastFailure() {
        return this.lastFailure;
    }

    @Nullable
    public Invocation lastSuccess() {
        return this.lastSuccess;
    }

    @Nullable
    public String modifiedDate() {
        return this.modifiedDate;
    }

    public String modifiedDateMillis() {
        return this.modifiedDateMillis;
    }

    @Nullable
    public String nextExecution() {
        return this.nextExecution;
    }

    public String nextExecutionMillis() {
        return this.nextExecutionMillis;
    }

    public Policy policy() {
        return this.policy;
    }

    public long version() {
        return this.version;
    }

    public Statistics stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.inProgress != null) {
            generator.writeKey("in_progress");
            this.inProgress.serialize(generator, mapper);
        }
        if (this.lastFailure != null) {
            generator.writeKey("last_failure");
            this.lastFailure.serialize(generator, mapper);
        }
        if (this.lastSuccess != null) {
            generator.writeKey("last_success");
            this.lastSuccess.serialize(generator, mapper);
        }
        if (this.modifiedDate != null) {
            generator.writeKey("modified_date");
            generator.write(this.modifiedDate);
        }
        generator.writeKey("modified_date_millis");
        generator.write(this.modifiedDateMillis);
        if (this.nextExecution != null) {
            generator.writeKey("next_execution");
            generator.write(this.nextExecution);
        }
        generator.writeKey("next_execution_millis");
        generator.write(this.nextExecutionMillis);
        generator.writeKey("policy");
        this.policy.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupSnapshotLifecycleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::inProgress, InProgress._DESERIALIZER, "in_progress", new String[0]);
        op.add(Builder::lastFailure, Invocation._DESERIALIZER, "last_failure", new String[0]);
        op.add(Builder::lastSuccess, Invocation._DESERIALIZER, "last_success", new String[0]);
        op.add(Builder::modifiedDate, JsonpDeserializer.stringDeserializer(), "modified_date", new String[0]);
        op.add(Builder::modifiedDateMillis, JsonpDeserializer.stringDeserializer(), "modified_date_millis", new String[0]);
        op.add(Builder::nextExecution, JsonpDeserializer.stringDeserializer(), "next_execution", new String[0]);
        op.add(Builder::nextExecutionMillis, JsonpDeserializer.stringDeserializer(), "next_execution_millis", new String[0]);
        op.add(Builder::policy, Policy._DESERIALIZER, "policy", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::stats, Statistics._DESERIALIZER, "stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotLifecycle> {
        @Nullable
        private InProgress inProgress;
        @Nullable
        private Invocation lastFailure;
        @Nullable
        private Invocation lastSuccess;
        @Nullable
        private String modifiedDate;
        private String modifiedDateMillis;
        @Nullable
        private String nextExecution;
        private String nextExecutionMillis;
        private Policy policy;
        private Long version;
        private Statistics stats;

        public Builder inProgress(@Nullable InProgress value) {
            this.inProgress = value;
            return this;
        }

        public Builder inProgress(Function<InProgress.Builder, ObjectBuilder<InProgress>> fn) {
            return this.inProgress(fn.apply(new InProgress.Builder()).build());
        }

        public Builder lastFailure(@Nullable Invocation value) {
            this.lastFailure = value;
            return this;
        }

        public Builder lastFailure(Function<Invocation.Builder, ObjectBuilder<Invocation>> fn) {
            return this.lastFailure(fn.apply(new Invocation.Builder()).build());
        }

        public Builder lastSuccess(@Nullable Invocation value) {
            this.lastSuccess = value;
            return this;
        }

        public Builder lastSuccess(Function<Invocation.Builder, ObjectBuilder<Invocation>> fn) {
            return this.lastSuccess(fn.apply(new Invocation.Builder()).build());
        }

        public Builder modifiedDate(@Nullable String value) {
            this.modifiedDate = value;
            return this;
        }

        public Builder modifiedDateMillis(String value) {
            this.modifiedDateMillis = value;
            return this;
        }

        public Builder nextExecution(@Nullable String value) {
            this.nextExecution = value;
            return this;
        }

        public Builder nextExecutionMillis(String value) {
            this.nextExecutionMillis = value;
            return this;
        }

        public Builder policy(Policy value) {
            this.policy = value;
            return this;
        }

        public Builder policy(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.policy(fn.apply(new Policy.Builder()).build());
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        public Builder stats(Statistics value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<Statistics.Builder, ObjectBuilder<Statistics>> fn) {
            return this.stats(fn.apply(new Statistics.Builder()).build());
        }

        @Override
        public SnapshotLifecycle build() {
            return new SnapshotLifecycle(this);
        }
    }
}

