/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.slm.Configuration;
import co.elastic.clients.elasticsearch.slm.PutLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.Retention;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutLifecycleRequest
extends RequestBase
implements JsonpSerializable {
    private final String policyId;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Configuration config;
    @Nullable
    private final String name;
    @Nullable
    private final String repository;
    @Nullable
    private final Retention retention;
    @Nullable
    private final String schedule;
    public static final JsonpDeserializer<PutLifecycleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutLifecycleRequest::setupPutLifecycleRequestDeserializer, Builder::build);
    public static final Endpoint<PutLifecycleRequest, PutLifecycleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutLifecycleRequest, PutLifecycleResponse>(request -> "PUT", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutLifecycleResponse._DESERIALIZER);

    public PutLifecycleRequest(Builder builder) {
        this.policyId = Objects.requireNonNull(builder.policyId, "policy_id");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.config = builder.config;
        this.name = builder.name;
        this.repository = builder.repository;
        this.retention = builder.retention;
        this.schedule = builder.schedule;
    }

    public PutLifecycleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String policyId() {
        return this.policyId;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Configuration config() {
        return this.config;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String repository() {
        return this.repository;
    }

    @Nullable
    public Retention retention() {
        return this.retention;
    }

    @Nullable
    public String schedule() {
        return this.schedule;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.config != null) {
            generator.writeKey("config");
            this.config.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
        if (this.schedule != null) {
            generator.writeKey("schedule");
            generator.write(this.schedule);
        }
    }

    protected static void setupPutLifecycleRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::config, Configuration._DESERIALIZER, "config", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", new String[0]);
        op.add(Builder::retention, Retention._DESERIALIZER, "retention", new String[0]);
        op.add(Builder::schedule, JsonpDeserializer.stringDeserializer(), "schedule", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutLifecycleRequest> {
        private String policyId;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Configuration config;
        @Nullable
        private String name;
        @Nullable
        private String repository;
        @Nullable
        private Retention retention;
        @Nullable
        private String schedule;

        public Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder config(@Nullable Configuration value) {
            this.config = value;
            return this;
        }

        public Builder config(Function<Configuration.Builder, ObjectBuilder<Configuration>> fn) {
            return this.config(fn.apply(new Configuration.Builder()).build());
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public Builder retention(@Nullable Retention value) {
            this.retention = value;
            return this;
        }

        public Builder retention(Function<Retention.Builder, ObjectBuilder<Retention>> fn) {
            return this.retention(fn.apply(new Retention.Builder()).build());
        }

        public Builder schedule(@Nullable String value) {
            this.schedule = value;
            return this;
        }

        @Override
        public PutLifecycleRequest build() {
            return new PutLifecycleRequest(this);
        }
    }
}

