/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch.slm.Configuration;
import co.elastic.clients.elasticsearch.slm.Retention;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Policy
implements JsonpSerializable {
    private final Configuration config;
    private final String name;
    private final String repository;
    private final Retention retention;
    private final String schedule;
    public static final JsonpDeserializer<Policy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Policy::setupPolicyDeserializer, Builder::build);

    public Policy(Builder builder) {
        this.config = Objects.requireNonNull(builder.config, "config");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.retention = Objects.requireNonNull(builder.retention, "retention");
        this.schedule = Objects.requireNonNull(builder.schedule, "schedule");
    }

    public Policy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Configuration config() {
        return this.config;
    }

    public String name() {
        return this.name;
    }

    public String repository() {
        return this.repository;
    }

    public Retention retention() {
        return this.retention;
    }

    public String schedule() {
        return this.schedule;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("config");
        this.config.serialize(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("repository");
        generator.write(this.repository);
        generator.writeKey("retention");
        this.retention.serialize(generator, mapper);
        generator.writeKey("schedule");
        generator.write(this.schedule);
    }

    protected static void setupPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::config, Configuration._DESERIALIZER, "config", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", new String[0]);
        op.add(Builder::retention, Retention._DESERIALIZER, "retention", new String[0]);
        op.add(Builder::schedule, JsonpDeserializer.stringDeserializer(), "schedule", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Policy> {
        private Configuration config;
        private String name;
        private String repository;
        private Retention retention;
        private String schedule;

        public Builder config(Configuration value) {
            this.config = value;
            return this;
        }

        public Builder config(Function<Configuration.Builder, ObjectBuilder<Configuration>> fn) {
            return this.config(fn.apply(new Configuration.Builder()).build());
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder retention(Retention value) {
            this.retention = value;
            return this;
        }

        public Builder retention(Function<Retention.Builder, ObjectBuilder<Retention>> fn) {
            return this.retention(fn.apply(new Retention.Builder()).build());
        }

        public Builder schedule(String value) {
            this.schedule = value;
            return this;
        }

        @Override
        public Policy build() {
            return new Policy(this);
        }
    }
}

