/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class InProgress
implements JsonpSerializable {
    private final String name;
    private final String startTimeMillis;
    private final String state;
    private final String uuid;
    public static final JsonpDeserializer<InProgress> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InProgress::setupInProgressDeserializer, Builder::build);

    public InProgress(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.startTimeMillis = Objects.requireNonNull(builder.startTimeMillis, "start_time_millis");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.uuid = Objects.requireNonNull(builder.uuid, "uuid");
    }

    public InProgress(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public String startTimeMillis() {
        return this.startTimeMillis;
    }

    public String state() {
        return this.state;
    }

    public String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("start_time_millis");
        generator.write(this.startTimeMillis);
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("uuid");
        generator.write(this.uuid);
    }

    protected static void setupInProgressDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::startTimeMillis, JsonpDeserializer.stringDeserializer(), "start_time_millis", new String[0]);
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", new String[0]);
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InProgress> {
        private String name;
        private String startTimeMillis;
        private String state;
        private String uuid;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder startTimeMillis(String value) {
            this.startTimeMillis = value;
            return this;
        }

        public Builder state(String value) {
            this.state = value;
            return this;
        }

        public Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Override
        public InProgress build() {
            return new InProgress(this);
        }
    }
}

