/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.shutdown.GetNodeResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetNodeRequest
extends RequestBase {
    @Nullable
    private final List<String> nodeId;
    public static final Endpoint<GetNodeRequest, GetNodeResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetNodeRequest, GetNodeResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/shutdown");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetNodeResponse._DESERIALIZER);

    public GetNodeRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
    }

    public GetNodeRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    public static class Builder
    implements ObjectBuilder<GetNodeRequest> {
        @Nullable
        private List<String> nodeId;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        @Override
        public GetNodeRequest build() {
            return new GetNodeRequest(this);
        }
    }
}

