/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteNodeRequest
extends RequestBase {
    private final String nodeId;
    public static final Endpoint<DeleteNodeRequest, DeleteNodeResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteNodeRequest, DeleteNodeResponse>(request -> "DELETE", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteNodeResponse._DESERIALIZER);

    public DeleteNodeRequest(Builder builder) {
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
    }

    public DeleteNodeRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeId() {
        return this.nodeId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteNodeRequest> {
        private String nodeId;

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Override
        public DeleteNodeRequest build() {
            return new DeleteNodeRequest(this);
        }
    }
}

