/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_role;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.get_role.TransientMetadata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Role
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndicesPrivileges> indices;
    private final Map<String, JsonData> metadata;
    private final List<String> runAs;
    private final TransientMetadata transientMetadata;
    private final List<ApplicationPrivileges> applications;
    @Nullable
    private final List<JsonValue> roleTemplates;
    public static final JsonpDeserializer<Role> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Role::setupRoleDeserializer, Builder::build);

    public Role(Builder builder) {
        this.cluster = ModelTypeHelper.unmodifiableNonNull(builder.cluster, "cluster");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.metadata = ModelTypeHelper.unmodifiableNonNull(builder.metadata, "metadata");
        this.runAs = ModelTypeHelper.unmodifiableNonNull(builder.runAs, "run_as");
        this.transientMetadata = Objects.requireNonNull(builder.transientMetadata, "transient_metadata");
        this.applications = ModelTypeHelper.unmodifiableNonNull(builder.applications, "applications");
        this.roleTemplates = ModelTypeHelper.unmodifiable(builder.roleTemplates);
    }

    public Role(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> cluster() {
        return this.cluster;
    }

    public List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public List<String> runAs() {
        return this.runAs;
    }

    public TransientMetadata transientMetadata() {
        return this.transientMetadata;
    }

    public List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    @Nullable
    public List<JsonValue> roleTemplates() {
        return this.roleTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster");
        generator.writeStartArray();
        for (String string : this.cluster) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesPrivileges indicesPrivileges : this.indices) {
            indicesPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("metadata");
        generator.writeStartObject();
        for (Map.Entry entry : this.metadata.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("run_as");
        generator.writeStartArray();
        for (String string : this.runAs) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("transient_metadata");
        this.transientMetadata.serialize(generator, mapper);
        generator.writeKey("applications");
        generator.writeStartArray();
        for (ApplicationPrivileges applicationPrivileges : this.applications) {
            applicationPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.roleTemplates != null) {
            generator.writeKey("role_templates");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.roleTemplates) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as", new String[0]);
        op.add(Builder::transientMetadata, TransientMetadata._DESERIALIZER, "transient_metadata", new String[0]);
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications", new String[0]);
        op.add(Builder::roleTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "role_templates", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Role> {
        private List<String> cluster;
        private List<IndicesPrivileges> indices;
        private Map<String, JsonData> metadata;
        private List<String> runAs;
        private TransientMetadata transientMetadata;
        private List<ApplicationPrivileges> applications;
        @Nullable
        private List<JsonValue> roleTemplates;

        public Builder cluster(List<String> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(String ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(String value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<String>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder indices(List<IndicesPrivileges> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesPrivileges ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesPrivileges value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesPrivileges>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder addIndices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.addIndices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder metadata(Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder runAs(List<String> value) {
            this.runAs = value;
            return this;
        }

        public Builder runAs(String ... value) {
            this.runAs = Arrays.asList(value);
            return this;
        }

        public Builder addRunAs(String value) {
            if (this.runAs == null) {
                this.runAs = new ArrayList<String>();
            }
            this.runAs.add(value);
            return this;
        }

        public Builder transientMetadata(TransientMetadata value) {
            this.transientMetadata = value;
            return this;
        }

        public Builder transientMetadata(Function<TransientMetadata.Builder, ObjectBuilder<TransientMetadata>> fn) {
            return this.transientMetadata(fn.apply(new TransientMetadata.Builder()).build());
        }

        public Builder applications(List<ApplicationPrivileges> value) {
            this.applications = value;
            return this;
        }

        public Builder applications(ApplicationPrivileges ... value) {
            this.applications = Arrays.asList(value);
            return this;
        }

        public Builder addApplications(ApplicationPrivileges value) {
            if (this.applications == null) {
                this.applications = new ArrayList<ApplicationPrivileges>();
            }
            this.applications.add(value);
            return this;
        }

        public Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder addApplications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.addApplications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder roleTemplates(@Nullable List<JsonValue> value) {
            this.roleTemplates = value;
            return this;
        }

        public Builder roleTemplates(JsonValue ... value) {
            this.roleTemplates = Arrays.asList(value);
            return this;
        }

        public Builder addRoleTemplates(JsonValue value) {
            if (this.roleTemplates == null) {
                this.roleTemplates = new ArrayList<JsonValue>();
            }
            this.roleTemplates.add(value);
            return this;
        }

        @Override
        public Role build() {
            return new Role(this);
        }
    }
}

