/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.create_api_key;

import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class IndexPrivileges
implements JsonpSerializable {
    private final List<String> names;
    private final List<IndexPrivilege> privileges;
    public static final JsonpDeserializer<IndexPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexPrivileges::setupIndexPrivilegesDeserializer, Builder::build);

    public IndexPrivileges(Builder builder) {
        this.names = ModelTypeHelper.unmodifiableNonNull(builder.names, "names");
        this.privileges = ModelTypeHelper.unmodifiableNonNull(builder.privileges, "privileges");
    }

    public IndexPrivileges(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> names() {
        return this.names;
    }

    public List<IndexPrivilege> privileges() {
        return this.privileges;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("names");
        generator.writeStartArray();
        for (String string : this.names) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("privileges");
        generator.writeStartArray();
        for (IndexPrivilege indexPrivilege : this.privileges) {
            indexPrivilege.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIndexPrivilegesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names", new String[0]);
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(IndexPrivilege._DESERIALIZER), "privileges", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexPrivileges> {
        private List<String> names;
        private List<IndexPrivilege> privileges;

        public Builder names(List<String> value) {
            this.names = value;
            return this;
        }

        public Builder names(String ... value) {
            this.names = Arrays.asList(value);
            return this;
        }

        public Builder addNames(String value) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(value);
            return this;
        }

        public Builder privileges(List<IndexPrivilege> value) {
            this.privileges = value;
            return this;
        }

        public Builder privileges(IndexPrivilege ... value) {
            this.privileges = Arrays.asList(value);
            return this;
        }

        public Builder addPrivileges(IndexPrivilege value) {
            if (this.privileges == null) {
                this.privileges = new ArrayList<IndexPrivilege>();
            }
            this.privileges.add(value);
            return this;
        }

        @Override
        public IndexPrivileges build() {
            return new IndexPrivileges(this);
        }
    }
}

