/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonpDeserializable
public class User
implements JsonpSerializable {
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final String username;
    private final boolean enabled;
    public static final JsonpDeserializer<User> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, User::setupUserDeserializer, Builder::build);

    public User(AbstractBuilder<?> builder) {
        this.email = ((AbstractBuilder)builder).email;
        this.fullName = ((AbstractBuilder)builder).fullName;
        this.metadata = ModelTypeHelper.unmodifiableNonNull(((AbstractBuilder)builder).metadata, "metadata");
        this.roles = ModelTypeHelper.unmodifiableNonNull(((AbstractBuilder)builder).roles, "roles");
        this.username = Objects.requireNonNull(((AbstractBuilder)builder).username, "username");
        this.enabled = Objects.requireNonNull(((AbstractBuilder)builder).enabled, "enabled");
    }

    @Nullable
    public String email() {
        return this.email;
    }

    @Nullable
    public String fullName() {
        return this.fullName;
    }

    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public List<String> roles() {
        return this.roles;
    }

    public String username() {
        return this.username;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        generator.writeKey("metadata");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("roles");
        generator.writeStartArray();
        for (String string : this.roles) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("enabled");
        generator.write(this.enabled);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupUserDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::email, JsonpDeserializer.stringDeserializer(), "email", new String[0]);
        op.add(AbstractBuilder::fullName, JsonpDeserializer.stringDeserializer(), "full_name", new String[0]);
        op.add(AbstractBuilder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(AbstractBuilder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private String username;
        private Boolean enabled;

        protected AbstractBuilder() {
        }

        public BuilderT email(@Nullable String value) {
            this.email = value;
            return this.self();
        }

        public BuilderT fullName(@Nullable String value) {
            this.fullName = value;
            return this.self();
        }

        public BuilderT metadata(Map<String, JsonData> value) {
            this.metadata = value;
            return this.self();
        }

        public BuilderT putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this.self();
        }

        public BuilderT roles(List<String> value) {
            this.roles = value;
            return this.self();
        }

        public BuilderT roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this.self();
        }

        public BuilderT username(String value) {
            this.username = value;
            return this.self();
        }

        public BuilderT enabled(boolean value) {
            this.enabled = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<User> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }
    }
}

