/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GrantApiKeyResponse;
import co.elastic.clients.elasticsearch.security.grant_api_key.ApiKey;
import co.elastic.clients.elasticsearch.security.grant_api_key.ApiKeyGrantType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GrantApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    private final ApiKey apiKey;
    private final ApiKeyGrantType grantType;
    @Nullable
    private final String accessToken;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    public static final JsonpDeserializer<GrantApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrantApiKeyRequest::setupGrantApiKeyRequestDeserializer, Builder::build);
    public static final Endpoint<GrantApiKeyRequest, GrantApiKeyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GrantApiKeyRequest, GrantApiKeyResponse>(request -> "POST", request -> "/_security/api_key/grant", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GrantApiKeyResponse._DESERIALIZER);

    public GrantApiKeyRequest(Builder builder) {
        this.apiKey = Objects.requireNonNull(builder.apiKey, "api_key");
        this.grantType = Objects.requireNonNull(builder.grantType, "grant_type");
        this.accessToken = builder.accessToken;
        this.username = builder.username;
        this.password = builder.password;
    }

    public GrantApiKeyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ApiKey apiKey() {
        return this.apiKey;
    }

    public ApiKeyGrantType grantType() {
        return this.grantType;
    }

    @Nullable
    public String accessToken() {
        return this.accessToken;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        this.apiKey.serialize(generator, mapper);
        generator.writeKey("grant_type");
        this.grantType.serialize(generator, mapper);
        if (this.accessToken != null) {
            generator.writeKey("access_token");
            generator.write(this.accessToken);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
    }

    protected static void setupGrantApiKeyRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::apiKey, ApiKey._DESERIALIZER, "api_key", new String[0]);
        op.add(Builder::grantType, ApiKeyGrantType._DESERIALIZER, "grant_type", new String[0]);
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GrantApiKeyRequest> {
        private ApiKey apiKey;
        private ApiKeyGrantType grantType;
        @Nullable
        private String accessToken;
        @Nullable
        private String username;
        @Nullable
        private String password;

        public Builder apiKey(ApiKey value) {
            this.apiKey = value;
            return this;
        }

        public Builder apiKey(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.apiKey(fn.apply(new ApiKey.Builder()).build());
        }

        public Builder grantType(ApiKeyGrantType value) {
            this.grantType = value;
            return this;
        }

        public Builder accessToken(@Nullable String value) {
            this.accessToken = value;
            return this;
        }

        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        public Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        @Override
        public GrantApiKeyRequest build() {
            return new GrantApiKeyRequest(this);
        }
    }
}

