/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.CreateServiceTokenResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class CreateServiceTokenRequest
extends RequestBase {
    private final String namespace;
    private final String service;
    private final String name;
    public static final Endpoint<CreateServiceTokenRequest, CreateServiceTokenResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CreateServiceTokenRequest, CreateServiceTokenResponse>(request -> {
        boolean _namespace = true;
        int _service = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            return "PUT";
        }
        if (propsSet == 3) {
            return "POST";
        }
        throw SimpleEndpoint.noPathTemplateFound("method");
    }, request -> {
        boolean _namespace = true;
        int _service = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, CreateServiceTokenResponse._DESERIALIZER);

    public CreateServiceTokenRequest(Builder builder) {
        this.namespace = Objects.requireNonNull(builder.namespace, "namespace");
        this.service = Objects.requireNonNull(builder.service, "service");
        this.name = Objects.requireNonNull(builder.name, "name");
    }

    public CreateServiceTokenRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String namespace() {
        return this.namespace;
    }

    public String service() {
        return this.service;
    }

    public String name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<CreateServiceTokenRequest> {
        private String namespace;
        private String service;
        private String name;

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder service(String value) {
            this.service = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public CreateServiceTokenRequest build() {
            return new CreateServiceTokenRequest(this);
        }
    }
}

