/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.rollup.delete_job.TaskFailure;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DeleteJobResponse
extends AcknowledgedResponseBase {
    @Nullable
    private final List<TaskFailure> taskFailures;
    public static final JsonpDeserializer<DeleteJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteJobResponse::setupDeleteJobResponseDeserializer, Builder::build);

    public DeleteJobResponse(Builder builder) {
        super(builder);
        this.taskFailures = ModelTypeHelper.unmodifiable(builder.taskFailures);
    }

    public DeleteJobResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<TaskFailure> taskFailures() {
        return this.taskFailures;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.taskFailures != null) {
            generator.writeKey("task_failures");
            generator.writeStartArray();
            for (TaskFailure item0 : this.taskFailures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDeleteJobResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::taskFailures, JsonpDeserializer.arrayDeserializer(TaskFailure._DESERIALIZER), "task_failures", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteJobResponse> {
        @Nullable
        private List<TaskFailure> taskFailures;

        public Builder taskFailures(@Nullable List<TaskFailure> value) {
            this.taskFailures = value;
            return this;
        }

        public Builder taskFailures(TaskFailure ... value) {
            this.taskFailures = Arrays.asList(value);
            return this;
        }

        public Builder addTaskFailures(TaskFailure value) {
            if (this.taskFailures == null) {
                this.taskFailures = new ArrayList<TaskFailure>();
            }
            this.taskFailures.add(value);
            return this;
        }

        public Builder taskFailures(Function<TaskFailure.Builder, ObjectBuilder<TaskFailure>> fn) {
            return this.taskFailures(fn.apply(new TaskFailure.Builder()).build());
        }

        public Builder addTaskFailures(Function<TaskFailure.Builder, ObjectBuilder<TaskFailure>> fn) {
            return this.addTaskFailures(fn.apply(new TaskFailure.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteJobResponse build() {
            return new DeleteJobResponse(this);
        }
    }
}

