/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeProcessInfo
implements JsonpSerializable {
    private final long id;
    private final boolean mlockall;
    private final long refreshIntervalInMillis;
    public static final JsonpDeserializer<NodeProcessInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeProcessInfo::setupNodeProcessInfoDeserializer, Builder::build);

    public NodeProcessInfo(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.mlockall = Objects.requireNonNull(builder.mlockall, "mlockall");
        this.refreshIntervalInMillis = Objects.requireNonNull(builder.refreshIntervalInMillis, "refresh_interval_in_millis");
    }

    public NodeProcessInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long id() {
        return this.id;
    }

    public boolean mlockall() {
        return this.mlockall;
    }

    public long refreshIntervalInMillis() {
        return this.refreshIntervalInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("mlockall");
        generator.write(this.mlockall);
        generator.writeKey("refresh_interval_in_millis");
        generator.write(this.refreshIntervalInMillis);
    }

    protected static void setupNodeProcessInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id", new String[0]);
        op.add(Builder::mlockall, JsonpDeserializer.booleanDeserializer(), "mlockall", new String[0]);
        op.add(Builder::refreshIntervalInMillis, JsonpDeserializer.longDeserializer(), "refresh_interval_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeProcessInfo> {
        private Long id;
        private Boolean mlockall;
        private Long refreshIntervalInMillis;

        public Builder id(long value) {
            this.id = value;
            return this;
        }

        public Builder mlockall(boolean value) {
            this.mlockall = value;
            return this;
        }

        public Builder refreshIntervalInMillis(long value) {
            this.refreshIntervalInMillis = value;
            return this;
        }

        @Override
        public NodeProcessInfo build() {
            return new NodeProcessInfo(this);
        }
    }
}

