/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.indices.IndexRouting;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsClusterElection;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoSettingsCluster
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final IndexRouting routing;
    private final NodeInfoSettingsClusterElection election;
    @Nullable
    private final String initialMasterNodes;
    public static final JsonpDeserializer<NodeInfoSettingsCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsCluster::setupNodeInfoSettingsClusterDeserializer, Builder::build);

    public NodeInfoSettingsCluster(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.routing = builder.routing;
        this.election = Objects.requireNonNull(builder.election, "election");
        this.initialMasterNodes = builder.initialMasterNodes;
    }

    public NodeInfoSettingsCluster(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public IndexRouting routing() {
        return this.routing;
    }

    public NodeInfoSettingsClusterElection election() {
        return this.election;
    }

    @Nullable
    public String initialMasterNodes() {
        return this.initialMasterNodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.routing != null) {
            generator.writeKey("routing");
            this.routing.serialize(generator, mapper);
        }
        generator.writeKey("election");
        this.election.serialize(generator, mapper);
        if (this.initialMasterNodes != null) {
            generator.writeKey("initial_master_nodes");
            generator.write(this.initialMasterNodes);
        }
    }

    protected static void setupNodeInfoSettingsClusterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::routing, IndexRouting._DESERIALIZER, "routing", new String[0]);
        op.add(Builder::election, NodeInfoSettingsClusterElection._DESERIALIZER, "election", new String[0]);
        op.add(Builder::initialMasterNodes, JsonpDeserializer.stringDeserializer(), "initial_master_nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoSettingsCluster> {
        private String name;
        @Nullable
        private IndexRouting routing;
        private NodeInfoSettingsClusterElection election;
        @Nullable
        private String initialMasterNodes;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder routing(@Nullable IndexRouting value) {
            this.routing = value;
            return this;
        }

        public Builder routing(Function<IndexRouting.Builder, ObjectBuilder<IndexRouting>> fn) {
            return this.routing(fn.apply(new IndexRouting.Builder()).build());
        }

        public Builder election(NodeInfoSettingsClusterElection value) {
            this.election = value;
            return this;
        }

        public Builder election(Function<NodeInfoSettingsClusterElection.Builder, ObjectBuilder<NodeInfoSettingsClusterElection>> fn) {
            return this.election(fn.apply(new NodeInfoSettingsClusterElection.Builder()).build());
        }

        public Builder initialMasterNodes(@Nullable String value) {
            this.initialMasterNodes = value;
            return this;
        }

        @Override
        public NodeInfoSettingsCluster build() {
            return new NodeInfoSettingsCluster(this);
        }
    }
}

