/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoOSCPU
implements JsonpSerializable {
    private final String cacheSize;
    private final int cacheSizeInBytes;
    private final int coresPerSocket;
    private final int mhz;
    private final String model;
    private final int totalCores;
    private final int totalSockets;
    private final String vendor;
    public static final JsonpDeserializer<NodeInfoOSCPU> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoOSCPU::setupNodeInfoOSCPUDeserializer, Builder::build);

    public NodeInfoOSCPU(Builder builder) {
        this.cacheSize = Objects.requireNonNull(builder.cacheSize, "cache_size");
        this.cacheSizeInBytes = Objects.requireNonNull(builder.cacheSizeInBytes, "cache_size_in_bytes");
        this.coresPerSocket = Objects.requireNonNull(builder.coresPerSocket, "cores_per_socket");
        this.mhz = Objects.requireNonNull(builder.mhz, "mhz");
        this.model = Objects.requireNonNull(builder.model, "model");
        this.totalCores = Objects.requireNonNull(builder.totalCores, "total_cores");
        this.totalSockets = Objects.requireNonNull(builder.totalSockets, "total_sockets");
        this.vendor = Objects.requireNonNull(builder.vendor, "vendor");
    }

    public NodeInfoOSCPU(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String cacheSize() {
        return this.cacheSize;
    }

    public int cacheSizeInBytes() {
        return this.cacheSizeInBytes;
    }

    public int coresPerSocket() {
        return this.coresPerSocket;
    }

    public int mhz() {
        return this.mhz;
    }

    public String model() {
        return this.model;
    }

    public int totalCores() {
        return this.totalCores;
    }

    public int totalSockets() {
        return this.totalSockets;
    }

    public String vendor() {
        return this.vendor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("cache_size_in_bytes");
        generator.write(this.cacheSizeInBytes);
        generator.writeKey("cores_per_socket");
        generator.write(this.coresPerSocket);
        generator.writeKey("mhz");
        generator.write(this.mhz);
        generator.writeKey("model");
        generator.write(this.model);
        generator.writeKey("total_cores");
        generator.write(this.totalCores);
        generator.writeKey("total_sockets");
        generator.write(this.totalSockets);
        generator.writeKey("vendor");
        generator.write(this.vendor);
    }

    protected static void setupNodeInfoOSCPUDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cacheSize, JsonpDeserializer.stringDeserializer(), "cache_size", new String[0]);
        op.add(Builder::cacheSizeInBytes, JsonpDeserializer.integerDeserializer(), "cache_size_in_bytes", new String[0]);
        op.add(Builder::coresPerSocket, JsonpDeserializer.integerDeserializer(), "cores_per_socket", new String[0]);
        op.add(Builder::mhz, JsonpDeserializer.integerDeserializer(), "mhz", new String[0]);
        op.add(Builder::model, JsonpDeserializer.stringDeserializer(), "model", new String[0]);
        op.add(Builder::totalCores, JsonpDeserializer.integerDeserializer(), "total_cores", new String[0]);
        op.add(Builder::totalSockets, JsonpDeserializer.integerDeserializer(), "total_sockets", new String[0]);
        op.add(Builder::vendor, JsonpDeserializer.stringDeserializer(), "vendor", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoOSCPU> {
        private String cacheSize;
        private Integer cacheSizeInBytes;
        private Integer coresPerSocket;
        private Integer mhz;
        private String model;
        private Integer totalCores;
        private Integer totalSockets;
        private String vendor;

        public Builder cacheSize(String value) {
            this.cacheSize = value;
            return this;
        }

        public Builder cacheSizeInBytes(int value) {
            this.cacheSizeInBytes = value;
            return this;
        }

        public Builder coresPerSocket(int value) {
            this.coresPerSocket = value;
            return this;
        }

        public Builder mhz(int value) {
            this.mhz = value;
            return this;
        }

        public Builder model(String value) {
            this.model = value;
            return this;
        }

        public Builder totalCores(int value) {
            this.totalCores = value;
            return this;
        }

        public Builder totalSockets(int value) {
            this.totalSockets = value;
            return this;
        }

        public Builder vendor(String value) {
            this.vendor = value;
            return this;
        }

        @Override
        public NodeInfoOSCPU build() {
            return new NodeInfoOSCPU(this);
        }
    }
}

