/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoMemory
implements JsonpSerializable {
    private final String total;
    private final long totalInBytes;
    public static final JsonpDeserializer<NodeInfoMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoMemory::setupNodeInfoMemoryDeserializer, Builder::build);

    public NodeInfoMemory(Builder builder) {
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
    }

    public NodeInfoMemory(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String total() {
        return this.total;
    }

    public long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupNodeInfoMemoryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoMemory> {
        private String total;
        private Long totalInBytes;

        public Builder total(String value) {
            this.total = value;
            return this;
        }

        public Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public NodeInfoMemory build() {
            return new NodeInfoMemory(this);
        }
    }
}

