/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.hot_threads;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HotThread
implements JsonpSerializable {
    private final List<String> hosts;
    private final String nodeId;
    private final String nodeName;
    private final List<String> threads;
    public static final JsonpDeserializer<HotThread> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HotThread::setupHotThreadDeserializer, Builder::build);

    public HotThread(Builder builder) {
        this.hosts = ModelTypeHelper.unmodifiableNonNull(builder.hosts, "hosts");
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.nodeName = Objects.requireNonNull(builder.nodeName, "node_name");
        this.threads = ModelTypeHelper.unmodifiableNonNull(builder.threads, "threads");
    }

    public HotThread(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> hosts() {
        return this.hosts;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public List<String> threads() {
        return this.threads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hosts");
        generator.writeStartArray();
        for (String item0 : this.hosts) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        generator.writeKey("threads");
        generator.writeStartArray();
        for (String item0 : this.threads) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupHotThreadDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::hosts, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "hosts", new String[0]);
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name", new String[0]);
        op.add(Builder::threads, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "threads", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HotThread> {
        private List<String> hosts;
        private String nodeId;
        private String nodeName;
        private List<String> threads;

        public Builder hosts(List<String> value) {
            this.hosts = value;
            return this;
        }

        public Builder hosts(String ... value) {
            this.hosts = Arrays.asList(value);
            return this;
        }

        public Builder addHosts(String value) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            this.hosts.add(value);
            return this;
        }

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public Builder threads(List<String> value) {
            this.threads = value;
            return this;
        }

        public Builder threads(String ... value) {
            this.threads = Arrays.asList(value);
            return this;
        }

        public Builder addThreads(String value) {
            if (this.threads == null) {
                this.threads = new ArrayList<String>();
            }
            this.threads.add(value);
            return this;
        }

        @Override
        public HotThread build() {
            return new HotThread(this);
        }
    }
}

