/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.elasticsearch.indices.stats.IndexStats;
import co.elastic.clients.elasticsearch.nodes.AdaptiveSelection;
import co.elastic.clients.elasticsearch.nodes.Breaker;
import co.elastic.clients.elasticsearch.nodes.FileSystem;
import co.elastic.clients.elasticsearch.nodes.Http;
import co.elastic.clients.elasticsearch.nodes.Ingest;
import co.elastic.clients.elasticsearch.nodes.Jvm;
import co.elastic.clients.elasticsearch.nodes.OperatingSystem;
import co.elastic.clients.elasticsearch.nodes.Process;
import co.elastic.clients.elasticsearch.nodes.Scripting;
import co.elastic.clients.elasticsearch.nodes.ThreadCount;
import co.elastic.clients.elasticsearch.nodes.Transport;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Stats
implements JsonpSerializable {
    private final Map<String, AdaptiveSelection> adaptiveSelection;
    private final Map<String, Breaker> breakers;
    private final FileSystem fs;
    private final String host;
    private final Http http;
    private final IndexStats indices;
    private final Ingest ingest;
    private final List<String> ip;
    private final Jvm jvm;
    private final String name;
    private final OperatingSystem os;
    private final Process process;
    private final List<NodeRole> roles;
    private final Scripting script;
    private final Map<String, ThreadCount> threadPool;
    private final long timestamp;
    private final Transport transport;
    private final String transportAddress;
    private final Map<String, String> attributes;
    public static final JsonpDeserializer<Stats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Stats::setupStatsDeserializer, Builder::build);

    public Stats(Builder builder) {
        this.adaptiveSelection = ModelTypeHelper.unmodifiableNonNull(builder.adaptiveSelection, "adaptive_selection");
        this.breakers = ModelTypeHelper.unmodifiableNonNull(builder.breakers, "breakers");
        this.fs = Objects.requireNonNull(builder.fs, "fs");
        this.host = Objects.requireNonNull(builder.host, "host");
        this.http = Objects.requireNonNull(builder.http, "http");
        this.indices = Objects.requireNonNull(builder.indices, "indices");
        this.ingest = Objects.requireNonNull(builder.ingest, "ingest");
        this.ip = ModelTypeHelper.unmodifiableNonNull(builder.ip, "ip");
        this.jvm = Objects.requireNonNull(builder.jvm, "jvm");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.os = Objects.requireNonNull(builder.os, "os");
        this.process = Objects.requireNonNull(builder.process, "process");
        this.roles = ModelTypeHelper.unmodifiableNonNull(builder.roles, "roles");
        this.script = Objects.requireNonNull(builder.script, "script");
        this.threadPool = ModelTypeHelper.unmodifiableNonNull(builder.threadPool, "thread_pool");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.transport = Objects.requireNonNull(builder.transport, "transport");
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
    }

    public Stats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, AdaptiveSelection> adaptiveSelection() {
        return this.adaptiveSelection;
    }

    public Map<String, Breaker> breakers() {
        return this.breakers;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public String host() {
        return this.host;
    }

    public Http http() {
        return this.http;
    }

    public IndexStats indices() {
        return this.indices;
    }

    public Ingest ingest() {
        return this.ingest;
    }

    public List<String> ip() {
        return this.ip;
    }

    public Jvm jvm() {
        return this.jvm;
    }

    public String name() {
        return this.name;
    }

    public OperatingSystem os() {
        return this.os;
    }

    public Process process() {
        return this.process;
    }

    public List<NodeRole> roles() {
        return this.roles;
    }

    public Scripting script() {
        return this.script;
    }

    public Map<String, ThreadCount> threadPool() {
        return this.threadPool;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Transport transport() {
        return this.transport;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("adaptive_selection");
        generator.writeStartObject();
        for (Map.Entry<String, AdaptiveSelection> entry : this.adaptiveSelection.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("breakers");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.breakers.entrySet()) {
            generator.writeKey(entry.getKey());
            ((Breaker)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("fs");
        this.fs.serialize(generator, mapper);
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("http");
        this.http.serialize(generator, mapper);
        generator.writeKey("indices");
        this.indices.serialize(generator, mapper);
        generator.writeKey("ingest");
        this.ingest.serialize(generator, mapper);
        generator.writeKey("ip");
        generator.writeStartArray();
        for (String string : this.ip) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("jvm");
        this.jvm.serialize(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("os");
        this.os.serialize(generator, mapper);
        generator.writeKey("process");
        this.process.serialize(generator, mapper);
        generator.writeKey("roles");
        generator.writeStartArray();
        for (NodeRole nodeRole : this.roles) {
            nodeRole.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        generator.writeKey("thread_pool");
        generator.writeStartObject();
        for (Map.Entry entry : this.threadPool.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((ThreadCount)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("transport");
        this.transport.serialize(generator, mapper);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry entry : this.attributes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
    }

    protected static void setupStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::adaptiveSelection, JsonpDeserializer.stringMapDeserializer(AdaptiveSelection._DESERIALIZER), "adaptive_selection", new String[0]);
        op.add(Builder::breakers, JsonpDeserializer.stringMapDeserializer(Breaker._DESERIALIZER), "breakers", new String[0]);
        op.add(Builder::fs, FileSystem._DESERIALIZER, "fs", new String[0]);
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(Builder::http, Http._DESERIALIZER, "http", new String[0]);
        op.add(Builder::indices, IndexStats._DESERIALIZER, "indices", new String[0]);
        op.add(Builder::ingest, Ingest._DESERIALIZER, "ingest", new String[0]);
        op.add(Builder::ip, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ip", new String[0]);
        op.add(Builder::jvm, Jvm._DESERIALIZER, "jvm", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::os, OperatingSystem._DESERIALIZER, "os", new String[0]);
        op.add(Builder::process, Process._DESERIALIZER, "process", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles", new String[0]);
        op.add(Builder::script, Scripting._DESERIALIZER, "script", new String[0]);
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(ThreadCount._DESERIALIZER), "thread_pool", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
        op.add(Builder::transport, Transport._DESERIALIZER, "transport", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Stats> {
        private Map<String, AdaptiveSelection> adaptiveSelection;
        private Map<String, Breaker> breakers;
        private FileSystem fs;
        private String host;
        private Http http;
        private IndexStats indices;
        private Ingest ingest;
        private List<String> ip;
        private Jvm jvm;
        private String name;
        private OperatingSystem os;
        private Process process;
        private List<NodeRole> roles;
        private Scripting script;
        private Map<String, ThreadCount> threadPool;
        private Long timestamp;
        private Transport transport;
        private String transportAddress;
        private Map<String, String> attributes;

        public Builder adaptiveSelection(Map<String, AdaptiveSelection> value) {
            this.adaptiveSelection = value;
            return this;
        }

        public Builder putAdaptiveSelection(String key, AdaptiveSelection value) {
            if (this.adaptiveSelection == null) {
                this.adaptiveSelection = new HashMap<String, AdaptiveSelection>();
            }
            this.adaptiveSelection.put(key, value);
            return this;
        }

        public Builder adaptiveSelection(String key, Function<AdaptiveSelection.Builder, ObjectBuilder<AdaptiveSelection>> fn) {
            return this.adaptiveSelection(Collections.singletonMap(key, fn.apply(new AdaptiveSelection.Builder()).build()));
        }

        public Builder putAdaptiveSelection(String key, Function<AdaptiveSelection.Builder, ObjectBuilder<AdaptiveSelection>> fn) {
            return this.putAdaptiveSelection(key, fn.apply(new AdaptiveSelection.Builder()).build());
        }

        public Builder breakers(Map<String, Breaker> value) {
            this.breakers = value;
            return this;
        }

        public Builder putBreakers(String key, Breaker value) {
            if (this.breakers == null) {
                this.breakers = new HashMap<String, Breaker>();
            }
            this.breakers.put(key, value);
            return this;
        }

        public Builder breakers(String key, Function<Breaker.Builder, ObjectBuilder<Breaker>> fn) {
            return this.breakers(Collections.singletonMap(key, fn.apply(new Breaker.Builder()).build()));
        }

        public Builder putBreakers(String key, Function<Breaker.Builder, ObjectBuilder<Breaker>> fn) {
            return this.putBreakers(key, fn.apply(new Breaker.Builder()).build());
        }

        public Builder fs(FileSystem value) {
            this.fs = value;
            return this;
        }

        public Builder fs(Function<FileSystem.Builder, ObjectBuilder<FileSystem>> fn) {
            return this.fs(fn.apply(new FileSystem.Builder()).build());
        }

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder http(Http value) {
            this.http = value;
            return this;
        }

        public Builder http(Function<Http.Builder, ObjectBuilder<Http>> fn) {
            return this.http(fn.apply(new Http.Builder()).build());
        }

        public Builder indices(IndexStats value) {
            this.indices = value;
            return this;
        }

        public Builder indices(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.indices(fn.apply(new IndexStats.Builder()).build());
        }

        public Builder ingest(Ingest value) {
            this.ingest = value;
            return this;
        }

        public Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public Builder ip(List<String> value) {
            this.ip = value;
            return this;
        }

        public Builder ip(String ... value) {
            this.ip = Arrays.asList(value);
            return this;
        }

        public Builder addIp(String value) {
            if (this.ip == null) {
                this.ip = new ArrayList<String>();
            }
            this.ip.add(value);
            return this;
        }

        public Builder jvm(Jvm value) {
            this.jvm = value;
            return this;
        }

        public Builder jvm(Function<Jvm.Builder, ObjectBuilder<Jvm>> fn) {
            return this.jvm(fn.apply(new Jvm.Builder()).build());
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder os(OperatingSystem value) {
            this.os = value;
            return this;
        }

        public Builder os(Function<OperatingSystem.Builder, ObjectBuilder<OperatingSystem>> fn) {
            return this.os(fn.apply(new OperatingSystem.Builder()).build());
        }

        public Builder process(Process value) {
            this.process = value;
            return this;
        }

        public Builder process(Function<Process.Builder, ObjectBuilder<Process>> fn) {
            return this.process(fn.apply(new Process.Builder()).build());
        }

        public Builder roles(List<NodeRole> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(NodeRole ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(NodeRole value) {
            if (this.roles == null) {
                this.roles = new ArrayList<NodeRole>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder script(Scripting value) {
            this.script = value;
            return this;
        }

        public Builder script(Function<Scripting.Builder, ObjectBuilder<Scripting>> fn) {
            return this.script(fn.apply(new Scripting.Builder()).build());
        }

        public Builder threadPool(Map<String, ThreadCount> value) {
            this.threadPool = value;
            return this;
        }

        public Builder putThreadPool(String key, ThreadCount value) {
            if (this.threadPool == null) {
                this.threadPool = new HashMap<String, ThreadCount>();
            }
            this.threadPool.put(key, value);
            return this;
        }

        public Builder threadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.threadPool(Collections.singletonMap(key, fn.apply(new ThreadCount.Builder()).build()));
        }

        public Builder putThreadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.putThreadPool(key, fn.apply(new ThreadCount.Builder()).build());
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public Builder transport(Transport value) {
            this.transport = value;
            return this;
        }

        public Builder transport(Function<Transport.Builder, ObjectBuilder<Transport>> fn) {
            return this.transport(fn.apply(new Transport.Builder()).build());
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public Builder attributes(Map<String, String> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        @Override
        public Stats build() {
            return new Stats(this);
        }
    }
}

