/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Cpu;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Process
implements JsonpSerializable {
    private final Cpu cpu;
    private final MemoryStats mem;
    private final int openFileDescriptors;
    private final long timestamp;
    public static final JsonpDeserializer<Process> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Process::setupProcessDeserializer, Builder::build);

    public Process(Builder builder) {
        this.cpu = Objects.requireNonNull(builder.cpu, "cpu");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.openFileDescriptors = Objects.requireNonNull(builder.openFileDescriptors, "open_file_descriptors");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public Process(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public MemoryStats mem() {
        return this.mem;
    }

    public int openFileDescriptors() {
        return this.openFileDescriptors;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("open_file_descriptors");
        generator.write(this.openFileDescriptors);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupProcessDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu", new String[0]);
        op.add(Builder::mem, MemoryStats._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::openFileDescriptors, JsonpDeserializer.integerDeserializer(), "open_file_descriptors", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Process> {
        private Cpu cpu;
        private MemoryStats mem;
        private Integer openFileDescriptors;
        private Long timestamp;

        public Builder cpu(Cpu value) {
            this.cpu = value;
            return this;
        }

        public Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public Builder mem(MemoryStats value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.mem(fn.apply(new MemoryStats.Builder()).build());
        }

        public Builder openFileDescriptors(int value) {
            this.openFileDescriptors = value;
            return this;
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public Process build() {
            return new Process(this);
        }
    }
}

