/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Process;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KeyedProcessor
implements JsonpSerializable {
    private final Process statistics;
    private final String type;
    public static final JsonpDeserializer<KeyedProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeyedProcessor::setupKeyedProcessorDeserializer, Builder::build);

    public KeyedProcessor(Builder builder) {
        this.statistics = Objects.requireNonNull(builder.statistics, "statistics");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public KeyedProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Process statistics() {
        return this.statistics;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("statistics");
        this.statistics.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupKeyedProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::statistics, Process._DESERIALIZER, "statistics", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<KeyedProcessor> {
        private Process statistics;
        private String type;

        public Builder statistics(Process value) {
            this.statistics = value;
            return this;
        }

        public Builder statistics(Function<Process.Builder, ObjectBuilder<Process>> fn) {
            return this.statistics(fn.apply(new Process.Builder()).build());
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public KeyedProcessor build() {
            return new KeyedProcessor(this);
        }
    }
}

