/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.KeyedProcessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IngestTotal
implements JsonpSerializable {
    private final long count;
    private final long current;
    private final long failed;
    private final List<KeyedProcessor> processors;
    private final long timeInMillis;
    public static final JsonpDeserializer<IngestTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestTotal::setupIngestTotalDeserializer, Builder::build);

    public IngestTotal(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.current = Objects.requireNonNull(builder.current, "current");
        this.failed = Objects.requireNonNull(builder.failed, "failed");
        this.processors = ModelTypeHelper.unmodifiableNonNull(builder.processors, "processors");
        this.timeInMillis = Objects.requireNonNull(builder.timeInMillis, "time_in_millis");
    }

    public IngestTotal(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public long current() {
        return this.current;
    }

    public long failed() {
        return this.failed;
    }

    public List<KeyedProcessor> processors() {
        return this.processors;
    }

    public long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("failed");
        generator.write(this.failed);
        generator.writeKey("processors");
        generator.writeStartArray();
        for (KeyedProcessor item0 : this.processors) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    protected static void setupIngestTotalDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current", new String[0]);
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed", new String[0]);
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(KeyedProcessor._DESERIALIZER), "processors", new String[0]);
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IngestTotal> {
        private Long count;
        private Long current;
        private Long failed;
        private List<KeyedProcessor> processors;
        private Long timeInMillis;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder current(long value) {
            this.current = value;
            return this;
        }

        public Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public Builder processors(List<KeyedProcessor> value) {
            this.processors = value;
            return this;
        }

        public Builder processors(KeyedProcessor ... value) {
            this.processors = Arrays.asList(value);
            return this;
        }

        public Builder addProcessors(KeyedProcessor value) {
            if (this.processors == null) {
                this.processors = new ArrayList<KeyedProcessor>();
            }
            this.processors.add(value);
            return this;
        }

        public Builder processors(Function<KeyedProcessor.Builder, ObjectBuilder<KeyedProcessor>> fn) {
            return this.processors(fn.apply(new KeyedProcessor.Builder()).build());
        }

        public Builder addProcessors(Function<KeyedProcessor.Builder, ObjectBuilder<KeyedProcessor>> fn) {
            return this.addProcessors(fn.apply(new KeyedProcessor.Builder()).build());
        }

        public Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        public IngestTotal build() {
            return new IngestTotal(this);
        }
    }
}

