/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.IngestTotal;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Ingest
implements JsonpSerializable {
    private final Map<String, IngestTotal> pipelines;
    private final IngestTotal total;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer, Builder::build);

    public Ingest(Builder builder) {
        this.pipelines = ModelTypeHelper.unmodifiableNonNull(builder.pipelines, "pipelines");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public Ingest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, IngestTotal> pipelines() {
        return this.pipelines;
    }

    public IngestTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipelines");
        generator.writeStartObject();
        for (Map.Entry<String, IngestTotal> item0 : this.pipelines.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupIngestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::pipelines, JsonpDeserializer.stringMapDeserializer(IngestTotal._DESERIALIZER), "pipelines", new String[0]);
        op.add(Builder::total, IngestTotal._DESERIALIZER, "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Ingest> {
        private Map<String, IngestTotal> pipelines;
        private IngestTotal total;

        public Builder pipelines(Map<String, IngestTotal> value) {
            this.pipelines = value;
            return this;
        }

        public Builder putPipelines(String key, IngestTotal value) {
            if (this.pipelines == null) {
                this.pipelines = new HashMap<String, IngestTotal>();
            }
            this.pipelines.put(key, value);
            return this;
        }

        public Builder pipelines(String key, Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.pipelines(Collections.singletonMap(key, fn.apply(new IngestTotal.Builder()).build()));
        }

        public Builder putPipelines(String key, Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.putPipelines(key, fn.apply(new IngestTotal.Builder()).build());
        }

        public Builder total(IngestTotal value) {
            this.total = value;
            return this;
        }

        public Builder total(Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.total(fn.apply(new IngestTotal.Builder()).build());
        }

        @Override
        public Ingest build() {
            return new Ingest(this);
        }
    }
}

