/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.monitoring;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BulkResponse
implements JsonpSerializable {
    @Nullable
    private final ErrorCause error;
    private final boolean errors;
    private final boolean ignored;
    private final long took;
    public static final JsonpDeserializer<BulkResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkResponse::setupBulkResponseDeserializer, Builder::build);

    public BulkResponse(Builder builder) {
        this.error = builder.error;
        this.errors = Objects.requireNonNull(builder.errors, "errors");
        this.ignored = Objects.requireNonNull(builder.ignored, "ignored");
        this.took = Objects.requireNonNull(builder.took, "took");
    }

    public BulkResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public ErrorCause error() {
        return this.error;
    }

    public boolean errors() {
        return this.errors;
    }

    public boolean ignored() {
        return this.ignored;
    }

    public long took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        generator.writeKey("errors");
        generator.write(this.errors);
        generator.writeKey("ignored");
        generator.write(this.ignored);
        generator.writeKey("took");
        generator.write(this.took);
    }

    protected static void setupBulkResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error", new String[0]);
        op.add(Builder::errors, JsonpDeserializer.booleanDeserializer(), "errors", new String[0]);
        op.add(Builder::ignored, JsonpDeserializer.booleanDeserializer(), "ignored", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BulkResponse> {
        @Nullable
        private ErrorCause error;
        private Boolean errors;
        private Boolean ignored;
        private Long took;

        public Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder errors(boolean value) {
            this.errors = value;
            return this;
        }

        public Builder ignored(boolean value) {
            this.ignored = value;
            return this;
        }

        public Builder took(long value) {
            this.took = value;
            return this;
        }

        @Override
        public BulkResponse build() {
            return new BulkResponse(this);
        }
    }
}

