/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FrequencyEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final String featureName;
    private final Map<String, Double> frequencyMap;
    public static final JsonpDeserializer<FrequencyEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequencyEncodingPreprocessor::setupFrequencyEncodingPreprocessorDeserializer, Builder::build);

    public FrequencyEncodingPreprocessor(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.featureName = Objects.requireNonNull(builder.featureName, "feature_name");
        this.frequencyMap = ModelTypeHelper.unmodifiableNonNull(builder.frequencyMap, "frequency_map");
    }

    public FrequencyEncodingPreprocessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "frequency_encoding";
    }

    public String field() {
        return this.field;
    }

    public String featureName() {
        return this.featureName;
    }

    public Map<String, Double> frequencyMap() {
        return this.frequencyMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("frequency_map");
        generator.writeStartObject();
        for (Map.Entry<String, Double> item0 : this.frequencyMap.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().doubleValue());
        }
        generator.writeEnd();
    }

    protected static void setupFrequencyEncodingPreprocessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name", new String[0]);
        op.add(Builder::frequencyMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "frequency_map", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FrequencyEncodingPreprocessor> {
        private String field;
        private String featureName;
        private Map<String, Double> frequencyMap;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public Builder frequencyMap(Map<String, Double> value) {
            this.frequencyMap = value;
            return this;
        }

        public Builder putFrequencyMap(String key, Double value) {
            if (this.frequencyMap == null) {
                this.frequencyMap = new HashMap<String, Double>();
            }
            this.frequencyMap.put(key, value);
            return this;
        }

        @Override
        public FrequencyEncodingPreprocessor build() {
            return new FrequencyEncodingPreprocessor(this);
        }
    }
}

