/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ConfusionMatrixThreshold
implements JsonpSerializable {
    private final int truePositive;
    private final int falsePositive;
    private final int trueNegative;
    private final int falseNegative;
    public static final JsonpDeserializer<ConfusionMatrixThreshold> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixThreshold::setupConfusionMatrixThresholdDeserializer, Builder::build);

    public ConfusionMatrixThreshold(Builder builder) {
        this.truePositive = Objects.requireNonNull(builder.truePositive, "tp");
        this.falsePositive = Objects.requireNonNull(builder.falsePositive, "fp");
        this.trueNegative = Objects.requireNonNull(builder.trueNegative, "tn");
        this.falseNegative = Objects.requireNonNull(builder.falseNegative, "fn");
    }

    public ConfusionMatrixThreshold(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int truePositive() {
        return this.truePositive;
    }

    public int falsePositive() {
        return this.falsePositive;
    }

    public int trueNegative() {
        return this.trueNegative;
    }

    public int falseNegative() {
        return this.falseNegative;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("tp");
        generator.write(this.truePositive);
        generator.writeKey("fp");
        generator.write(this.falsePositive);
        generator.writeKey("tn");
        generator.write(this.trueNegative);
        generator.writeKey("fn");
        generator.write(this.falseNegative);
    }

    protected static void setupConfusionMatrixThresholdDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::truePositive, JsonpDeserializer.integerDeserializer(), "tp", new String[0]);
        op.add(Builder::falsePositive, JsonpDeserializer.integerDeserializer(), "fp", new String[0]);
        op.add(Builder::trueNegative, JsonpDeserializer.integerDeserializer(), "tn", new String[0]);
        op.add(Builder::falseNegative, JsonpDeserializer.integerDeserializer(), "fn", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ConfusionMatrixThreshold> {
        private Integer truePositive;
        private Integer falsePositive;
        private Integer trueNegative;
        private Integer falseNegative;

        public Builder truePositive(int value) {
            this.truePositive = value;
            return this;
        }

        public Builder falsePositive(int value) {
            this.falsePositive = value;
            return this;
        }

        public Builder trueNegative(int value) {
            this.trueNegative = value;
            return this;
        }

        public Builder falseNegative(int value) {
            this.falseNegative = value;
            return this;
        }

        @Override
        public ConfusionMatrixThreshold build() {
            return new ConfusionMatrixThreshold(this);
        }
    }
}

