/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateModelSnapshotResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateModelSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    private final String snapshotId;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean retain;
    public static final JsonpDeserializer<UpdateModelSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateModelSnapshotRequest::setupUpdateModelSnapshotRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateModelSnapshotRequest, UpdateModelSnapshotResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateModelSnapshotRequest, UpdateModelSnapshotResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _snapshotId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateModelSnapshotResponse._DESERIALIZER);

    public UpdateModelSnapshotRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.snapshotId = Objects.requireNonNull(builder.snapshotId, "snapshot_id");
        this.description = builder.description;
        this.retain = builder.retain;
    }

    public UpdateModelSnapshotRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public Boolean retain() {
        return this.retain;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.retain != null) {
            generator.writeKey("retain");
            generator.write(this.retain.booleanValue());
        }
    }

    protected static void setupUpdateModelSnapshotRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::retain, JsonpDeserializer.booleanDeserializer(), "retain", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateModelSnapshotRequest> {
        private String jobId;
        private String snapshotId;
        @Nullable
        private String description;
        @Nullable
        private Boolean retain;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder retain(@Nullable Boolean value) {
            this.retain = value;
            return this;
        }

        @Override
        public UpdateModelSnapshotRequest build() {
            return new UpdateModelSnapshotRequest(this);
        }
    }
}

