/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelInferenceStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TrainedModelStats
implements JsonpSerializable {
    private final String modelId;
    private final int pipelineCount;
    @Nullable
    private final TrainedModelInferenceStats inferenceStats;
    @Nullable
    private final Map<String, JsonData> ingest;
    public static final JsonpDeserializer<TrainedModelStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelStats::setupTrainedModelStatsDeserializer, Builder::build);

    public TrainedModelStats(Builder builder) {
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.pipelineCount = Objects.requireNonNull(builder.pipelineCount, "pipeline_count");
        this.inferenceStats = builder.inferenceStats;
        this.ingest = ModelTypeHelper.unmodifiable(builder.ingest);
    }

    public TrainedModelStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelId() {
        return this.modelId;
    }

    public int pipelineCount() {
        return this.pipelineCount;
    }

    @Nullable
    public TrainedModelInferenceStats inferenceStats() {
        return this.inferenceStats;
    }

    @Nullable
    public Map<String, JsonData> ingest() {
        return this.ingest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("pipeline_count");
        generator.write(this.pipelineCount);
        if (this.inferenceStats != null) {
            generator.writeKey("inference_stats");
            this.inferenceStats.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.ingest.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTrainedModelStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id", new String[0]);
        op.add(Builder::pipelineCount, JsonpDeserializer.integerDeserializer(), "pipeline_count", new String[0]);
        op.add(Builder::inferenceStats, TrainedModelInferenceStats._DESERIALIZER, "inference_stats", new String[0]);
        op.add(Builder::ingest, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "ingest", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TrainedModelStats> {
        private String modelId;
        private Integer pipelineCount;
        @Nullable
        private TrainedModelInferenceStats inferenceStats;
        @Nullable
        private Map<String, JsonData> ingest;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder pipelineCount(int value) {
            this.pipelineCount = value;
            return this;
        }

        public Builder inferenceStats(@Nullable TrainedModelInferenceStats value) {
            this.inferenceStats = value;
            return this;
        }

        public Builder inferenceStats(Function<TrainedModelInferenceStats.Builder, ObjectBuilder<TrainedModelInferenceStats>> fn) {
            return this.inferenceStats(fn.apply(new TrainedModelInferenceStats.Builder()).build());
        }

        public Builder ingest(@Nullable Map<String, JsonData> value) {
            this.ingest = value;
            return this;
        }

        public Builder putIngest(String key, JsonData value) {
            if (this.ingest == null) {
                this.ingest = new HashMap<String, JsonData>();
            }
            this.ingest.put(key, value);
            return this;
        }

        @Override
        public TrainedModelStats build() {
            return new TrainedModelStats(this);
        }
    }
}

