/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TrainedModelInferenceStats
implements JsonpSerializable {
    private final long failureCount;
    private final long inferenceCount;
    private final long cacheMissCount;
    private final long missingAllFieldsCount;
    private final String timestamp;
    public static final JsonpDeserializer<TrainedModelInferenceStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelInferenceStats::setupTrainedModelInferenceStatsDeserializer, Builder::build);

    public TrainedModelInferenceStats(Builder builder) {
        this.failureCount = Objects.requireNonNull(builder.failureCount, "failure_count");
        this.inferenceCount = Objects.requireNonNull(builder.inferenceCount, "inference_count");
        this.cacheMissCount = Objects.requireNonNull(builder.cacheMissCount, "cache_miss_count");
        this.missingAllFieldsCount = Objects.requireNonNull(builder.missingAllFieldsCount, "missing_all_fields_count");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public TrainedModelInferenceStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long failureCount() {
        return this.failureCount;
    }

    public long inferenceCount() {
        return this.inferenceCount;
    }

    public long cacheMissCount() {
        return this.cacheMissCount;
    }

    public long missingAllFieldsCount() {
        return this.missingAllFieldsCount;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failure_count");
        generator.write(this.failureCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("cache_miss_count");
        generator.write(this.cacheMissCount);
        generator.writeKey("missing_all_fields_count");
        generator.write(this.missingAllFieldsCount);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupTrainedModelInferenceStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::failureCount, JsonpDeserializer.longDeserializer(), "failure_count", new String[0]);
        op.add(Builder::inferenceCount, JsonpDeserializer.longDeserializer(), "inference_count", new String[0]);
        op.add(Builder::cacheMissCount, JsonpDeserializer.longDeserializer(), "cache_miss_count", new String[0]);
        op.add(Builder::missingAllFieldsCount, JsonpDeserializer.longDeserializer(), "missing_all_fields_count", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TrainedModelInferenceStats> {
        private Long failureCount;
        private Long inferenceCount;
        private Long cacheMissCount;
        private Long missingAllFieldsCount;
        private String timestamp;

        public Builder failureCount(long value) {
            this.failureCount = value;
            return this;
        }

        public Builder inferenceCount(long value) {
            this.inferenceCount = value;
            return this;
        }

        public Builder cacheMissCount(long value) {
            this.cacheMissCount = value;
            return this;
        }

        public Builder missingAllFieldsCount(long value) {
            this.missingAllFieldsCount = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public TrainedModelInferenceStats build() {
            return new TrainedModelInferenceStats(this);
        }
    }
}

