/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.StartDatafeedResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StartDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    private final String datafeedId;
    @Nullable
    private final String end;
    @Nullable
    private final String start;
    @Nullable
    private final String timeout;
    public static final JsonpDeserializer<StartDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StartDatafeedRequest::setupStartDatafeedRequestDeserializer, Builder::build);
    public static final Endpoint<StartDatafeedRequest, StartDatafeedResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StartDatafeedRequest, StartDatafeedResponse>(request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap params = new HashMap();
        return params;
    }, SimpleEndpoint.emptyMap(), true, StartDatafeedResponse._DESERIALIZER);

    public StartDatafeedRequest(Builder builder) {
        this.datafeedId = Objects.requireNonNull(builder.datafeedId, "datafeed_id");
        this.end = builder.end;
        this.start = builder.start;
        this.timeout = builder.timeout;
    }

    public StartDatafeedRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
    }

    protected static void setupStartDatafeedRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end", new String[0]);
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StartDatafeedRequest> {
        private String datafeedId;
        @Nullable
        private String end;
        @Nullable
        private String start;
        @Nullable
        private String timeout;

        public Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public StartDatafeedRequest build() {
            return new StartDatafeedRequest(this);
        }
    }
}

