/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.RevertModelSnapshotResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RevertModelSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    private final String snapshotId;
    @Nullable
    private final Boolean deleteInterveningResults;
    public static final JsonpDeserializer<RevertModelSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RevertModelSnapshotRequest::setupRevertModelSnapshotRequestDeserializer, Builder::build);
    public static final Endpoint<RevertModelSnapshotRequest, RevertModelSnapshotResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RevertModelSnapshotRequest, RevertModelSnapshotResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _snapshotId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_revert");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RevertModelSnapshotResponse._DESERIALIZER);

    public RevertModelSnapshotRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.snapshotId = Objects.requireNonNull(builder.snapshotId, "snapshot_id");
        this.deleteInterveningResults = builder.deleteInterveningResults;
    }

    public RevertModelSnapshotRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public Boolean deleteInterveningResults() {
        return this.deleteInterveningResults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deleteInterveningResults != null) {
            generator.writeKey("delete_intervening_results");
            generator.write(this.deleteInterveningResults.booleanValue());
        }
    }

    protected static void setupRevertModelSnapshotRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::deleteInterveningResults, JsonpDeserializer.booleanDeserializer(), "delete_intervening_results", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RevertModelSnapshotRequest> {
        private String jobId;
        private String snapshotId;
        @Nullable
        private Boolean deleteInterveningResults;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public Builder deleteInterveningResults(@Nullable Boolean value) {
            this.deleteInterveningResults = value;
            return this;
        }

        @Override
        public RevertModelSnapshotRequest build() {
            return new RevertModelSnapshotRequest(this);
        }
    }
}

