/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.AnalysisLimits;
import co.elastic.clients.elasticsearch.ml.CustomSettings;
import co.elastic.clients.elasticsearch.ml.DataDescription;
import co.elastic.clients.elasticsearch.ml.DatafeedConfig;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.elasticsearch.ml.PutJobResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutJobRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final Boolean allowLazyOpen;
    private final AnalysisConfig analysisConfig;
    @Nullable
    private final AnalysisLimits analysisLimits;
    private final String backgroundPersistInterval;
    @Nullable
    private final CustomSettings customSettings;
    @Nullable
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final DataDescription dataDescription;
    @Nullable
    private final DatafeedConfig datafeedConfig;
    @Nullable
    private final String description;
    @Nullable
    private final List<String> groups;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final Long modelSnapshotRetentionDays;
    @Nullable
    private final Long renormalizationWindowDays;
    @Nullable
    private final String resultsIndexName;
    @Nullable
    private final Long resultsRetentionDays;
    public static final JsonpDeserializer<PutJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJobRequest::setupPutJobRequestDeserializer, Builder::build);
    public static final Endpoint<PutJobRequest, PutJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutJobRequest, PutJobResponse>(request -> "PUT", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutJobResponse._DESERIALIZER);

    public PutJobRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.allowLazyOpen = builder.allowLazyOpen;
        this.analysisConfig = Objects.requireNonNull(builder.analysisConfig, "analysis_config");
        this.analysisLimits = builder.analysisLimits;
        this.backgroundPersistInterval = Objects.requireNonNull(builder.backgroundPersistInterval, "background_persist_interval");
        this.customSettings = builder.customSettings;
        this.dailyModelSnapshotRetentionAfterDays = builder.dailyModelSnapshotRetentionAfterDays;
        this.dataDescription = Objects.requireNonNull(builder.dataDescription, "data_description");
        this.datafeedConfig = builder.datafeedConfig;
        this.description = builder.description;
        this.groups = ModelTypeHelper.unmodifiable(builder.groups);
        this.modelPlotConfig = builder.modelPlotConfig;
        this.modelSnapshotRetentionDays = builder.modelSnapshotRetentionDays;
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsIndexName = builder.resultsIndexName;
        this.resultsRetentionDays = builder.resultsRetentionDays;
    }

    public PutJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    public AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    @Nullable
    public AnalysisLimits analysisLimits() {
        return this.analysisLimits;
    }

    public String backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    @Nullable
    public CustomSettings customSettings() {
        return this.customSettings;
    }

    @Nullable
    public Long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public DataDescription dataDescription() {
        return this.dataDescription;
    }

    @Nullable
    public DatafeedConfig datafeedConfig() {
        return this.datafeedConfig;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<String> groups() {
        return this.groups;
    }

    @Nullable
    public ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public Long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    @Nullable
    public String resultsIndexName() {
        return this.resultsIndexName;
    }

    @Nullable
    public Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyOpen != null) {
            generator.writeKey("allow_lazy_open");
            generator.write(this.allowLazyOpen.booleanValue());
        }
        generator.writeKey("analysis_config");
        this.analysisConfig.serialize(generator, mapper);
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        generator.writeKey("background_persist_interval");
        generator.write(this.backgroundPersistInterval);
        if (this.customSettings != null) {
            generator.writeKey("custom_settings");
            this.customSettings.serialize(generator, mapper);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            generator.writeKey("daily_model_snapshot_retention_after_days");
            generator.write(this.dailyModelSnapshotRetentionAfterDays.longValue());
        }
        generator.writeKey("data_description");
        this.dataDescription.serialize(generator, mapper);
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.groups != null) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String item0 : this.groups) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.modelSnapshotRetentionDays != null) {
            generator.writeKey("model_snapshot_retention_days");
            generator.write(this.modelSnapshotRetentionDays.longValue());
        }
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays.longValue());
        }
        if (this.resultsIndexName != null) {
            generator.writeKey("results_index_name");
            generator.write(this.resultsIndexName);
        }
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays.longValue());
        }
    }

    protected static void setupPutJobRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open", new String[0]);
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config", new String[0]);
        op.add(Builder::analysisLimits, AnalysisLimits._DESERIALIZER, "analysis_limits", new String[0]);
        op.add(Builder::backgroundPersistInterval, JsonpDeserializer.stringDeserializer(), "background_persist_interval", new String[0]);
        op.add(Builder::customSettings, CustomSettings._DESERIALIZER, "custom_settings", new String[0]);
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days", new String[0]);
        op.add(Builder::dataDescription, DataDescription._DESERIALIZER, "data_description", new String[0]);
        op.add(Builder::datafeedConfig, DatafeedConfig._DESERIALIZER, "datafeed_config", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups", new String[0]);
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config", new String[0]);
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days", new String[0]);
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days", new String[0]);
        op.add(Builder::resultsIndexName, JsonpDeserializer.stringDeserializer(), "results_index_name", new String[0]);
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutJobRequest> {
        private String jobId;
        @Nullable
        private Boolean allowLazyOpen;
        private AnalysisConfig analysisConfig;
        @Nullable
        private AnalysisLimits analysisLimits;
        private String backgroundPersistInterval;
        @Nullable
        private CustomSettings customSettings;
        @Nullable
        private Long dailyModelSnapshotRetentionAfterDays;
        private DataDescription dataDescription;
        @Nullable
        private DatafeedConfig datafeedConfig;
        @Nullable
        private String description;
        @Nullable
        private List<String> groups;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private Long modelSnapshotRetentionDays;
        @Nullable
        private Long renormalizationWindowDays;
        @Nullable
        private String resultsIndexName;
        @Nullable
        private Long resultsRetentionDays;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder allowLazyOpen(@Nullable Boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public Builder analysisConfig(AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public Builder analysisLimits(@Nullable AnalysisLimits value) {
            this.analysisLimits = value;
            return this;
        }

        public Builder analysisLimits(Function<AnalysisLimits.Builder, ObjectBuilder<AnalysisLimits>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisLimits.Builder()).build());
        }

        public Builder backgroundPersistInterval(String value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public Builder customSettings(@Nullable CustomSettings value) {
            this.customSettings = value;
            return this;
        }

        public Builder customSettings(Function<CustomSettings.Builder, ObjectBuilder<CustomSettings>> fn) {
            return this.customSettings(fn.apply(new CustomSettings.Builder()).build());
        }

        public Builder dailyModelSnapshotRetentionAfterDays(@Nullable Long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public Builder dataDescription(DataDescription value) {
            this.dataDescription = value;
            return this;
        }

        public Builder dataDescription(Function<DataDescription.Builder, ObjectBuilder<DataDescription>> fn) {
            return this.dataDescription(fn.apply(new DataDescription.Builder()).build());
        }

        public Builder datafeedConfig(@Nullable DatafeedConfig value) {
            this.datafeedConfig = value;
            return this;
        }

        public Builder datafeedConfig(Function<DatafeedConfig.Builder, ObjectBuilder<DatafeedConfig>> fn) {
            return this.datafeedConfig(fn.apply(new DatafeedConfig.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder groups(@Nullable List<String> value) {
            this.groups = value;
            return this;
        }

        public Builder groups(String ... value) {
            this.groups = Arrays.asList(value);
            return this;
        }

        public Builder addGroups(String value) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(value);
            return this;
        }

        public Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public Builder modelSnapshotRetentionDays(@Nullable Long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public Builder resultsIndexName(@Nullable String value) {
            this.resultsIndexName = value;
            return this;
        }

        public Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        @Override
        public PutJobRequest build() {
            return new PutJobRequest(this);
        }
    }
}

