/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DatafeedIndicesOptions;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutDatafeedResponse
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    private final ChunkingConfig chunkingConfig;
    @Nullable
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final String datafeedId;
    private final String frequency;
    private final List<String> indices;
    private final String jobId;
    @Nullable
    private final DatafeedIndicesOptions indicesOptions;
    private final int maxEmptySearches;
    private final Query query;
    private final String queryDelay;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    private final int scrollSize;
    public static final JsonpDeserializer<PutDatafeedResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDatafeedResponse::setupPutDatafeedResponseDeserializer, Builder::build);

    public PutDatafeedResponse(Builder builder) {
        this.aggregations = ModelTypeHelper.unmodifiableNonNull(builder.aggregations, "aggregations");
        this.chunkingConfig = Objects.requireNonNull(builder.chunkingConfig, "chunking_config");
        this.delayedDataCheckConfig = builder.delayedDataCheckConfig;
        this.datafeedId = Objects.requireNonNull(builder.datafeedId, "datafeed_id");
        this.frequency = Objects.requireNonNull(builder.frequency, "frequency");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.indicesOptions = builder.indicesOptions;
        this.maxEmptySearches = Objects.requireNonNull(builder.maxEmptySearches, "max_empty_searches");
        this.query = Objects.requireNonNull(builder.query, "query");
        this.queryDelay = Objects.requireNonNull(builder.queryDelay, "query_delay");
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = Objects.requireNonNull(builder.scrollSize, "scroll_size");
    }

    public PutDatafeedResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    public ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    @Nullable
    public DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public String datafeedId() {
        return this.datafeedId;
    }

    public String frequency() {
        return this.frequency;
    }

    public List<String> indices() {
        return this.indices;
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public DatafeedIndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public int maxEmptySearches() {
        return this.maxEmptySearches;
    }

    public Query query() {
        return this.query;
    }

    public String queryDelay() {
        return this.queryDelay;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public int scrollSize() {
        return this.scrollSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregations");
        generator.writeStartObject();
        for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("chunking_config");
        this.chunkingConfig.serialize(generator, mapper);
        if (this.delayedDataCheckConfig != null) {
            generator.writeKey("delayed_data_check_config");
            this.delayedDataCheckConfig.serialize(generator, mapper);
        }
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        generator.writeKey("frequency");
        generator.write(this.frequency);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        generator.writeKey("max_empty_searches");
        generator.write(this.maxEmptySearches);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("query_delay");
        generator.write(this.queryDelay);
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("scroll_size");
        generator.write(this.scrollSize);
    }

    protected static void setupPutDatafeedResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", new String[0]);
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config", new String[0]);
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config", new String[0]);
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id", new String[0]);
        op.add(Builder::frequency, JsonpDeserializer.stringDeserializer(), "frequency", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::indicesOptions, DatafeedIndicesOptions._DESERIALIZER, "indices_options", new String[0]);
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::queryDelay, JsonpDeserializer.stringDeserializer(), "query_delay", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutDatafeedResponse> {
        private Map<String, Aggregation> aggregations;
        private ChunkingConfig chunkingConfig;
        @Nullable
        private DelayedDataCheckConfig delayedDataCheckConfig;
        private String datafeedId;
        private String frequency;
        private List<String> indices;
        private String jobId;
        @Nullable
        private DatafeedIndicesOptions indicesOptions;
        private Integer maxEmptySearches;
        private Query query;
        private String queryDelay;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        private Integer scrollSize;

        public Builder aggregations(Map<String, Aggregation> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, Aggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, Aggregation>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder chunkingConfig(ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public Builder delayedDataCheckConfig(@Nullable DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder frequency(String value) {
            this.frequency = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder indicesOptions(@Nullable DatafeedIndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public Builder indicesOptions(Function<DatafeedIndicesOptions.Builder, ObjectBuilder<DatafeedIndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new DatafeedIndicesOptions.Builder()).build());
        }

        public Builder maxEmptySearches(int value) {
            this.maxEmptySearches = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder queryDelay(String value) {
            this.queryDelay = value;
            return this;
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder scrollSize(int value) {
            this.scrollSize = value;
            return this;
        }

        @Override
        public PutDatafeedResponse build() {
            return new PutDatafeedResponse(this);
        }
    }
}

