/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DatafeedConfig;
import co.elastic.clients.elasticsearch.ml.JobConfig;
import co.elastic.clients.elasticsearch.ml.PreviewDatafeedResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PreviewDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String datafeedId;
    @Nullable
    private final JobConfig jobConfig;
    @Nullable
    private final DatafeedConfig datafeedConfig;
    public static final JsonpDeserializer<PreviewDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDatafeedRequest::setupPreviewDatafeedRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<PreviewDatafeedRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, null);

    public PreviewDatafeedRequest(Builder builder) {
        this.datafeedId = builder.datafeedId;
        this.jobConfig = builder.jobConfig;
        this.datafeedConfig = builder.datafeedConfig;
    }

    public PreviewDatafeedRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public JobConfig jobConfig() {
        return this.jobConfig;
    }

    @Nullable
    public DatafeedConfig datafeedConfig() {
        return this.datafeedConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.jobConfig != null) {
            generator.writeKey("job_config");
            this.jobConfig.serialize(generator, mapper);
        }
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
    }

    protected static void setupPreviewDatafeedRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::jobConfig, JobConfig._DESERIALIZER, "job_config", new String[0]);
        op.add(Builder::datafeedConfig, DatafeedConfig._DESERIALIZER, "datafeed_config", new String[0]);
    }

    public static <TDocument> Endpoint<PreviewDatafeedRequest, PreviewDatafeedResponse<TDocument>, ElasticsearchError> createPreviewDatafeedEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(PreviewDatafeedResponse.createPreviewDatafeedResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<PreviewDatafeedRequest> {
        @Nullable
        private String datafeedId;
        @Nullable
        private JobConfig jobConfig;
        @Nullable
        private DatafeedConfig datafeedConfig;

        public Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder jobConfig(@Nullable JobConfig value) {
            this.jobConfig = value;
            return this;
        }

        public Builder jobConfig(Function<JobConfig.Builder, ObjectBuilder<JobConfig>> fn) {
            return this.jobConfig(fn.apply(new JobConfig.Builder()).build());
        }

        public Builder datafeedConfig(@Nullable DatafeedConfig value) {
            this.datafeedConfig = value;
            return this;
        }

        public Builder datafeedConfig(Function<DatafeedConfig.Builder, ObjectBuilder<DatafeedConfig>> fn) {
            return this.datafeedConfig(fn.apply(new DatafeedConfig.Builder()).build());
        }

        @Override
        public PreviewDatafeedRequest build() {
            return new PreviewDatafeedRequest(this);
        }
    }
}

