/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class PreviewDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final List<Map<String, String>> featureValues;
    public static final JsonpDeserializer<PreviewDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDataFrameAnalyticsResponse::setupPreviewDataFrameAnalyticsResponseDeserializer, Builder::build);

    public PreviewDataFrameAnalyticsResponse(Builder builder) {
        this.featureValues = ModelTypeHelper.unmodifiableNonNull(builder.featureValues, "feature_values");
    }

    public PreviewDataFrameAnalyticsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Map<String, String>> featureValues() {
        return this.featureValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_values");
        generator.writeStartArray();
        for (Map<String, String> item0 : this.featureValues) {
            generator.writeStartObject();
            for (Map.Entry<String, String> item1 : item0.entrySet()) {
                generator.writeKey(item1.getKey());
                generator.write(item1.getValue());
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupPreviewDataFrameAnalyticsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::featureValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "feature_values", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PreviewDataFrameAnalyticsResponse> {
        private List<Map<String, String>> featureValues;

        public Builder featureValues(List<Map<String, String>> value) {
            this.featureValues = value;
            return this;
        }

        public Builder featureValues(Map<String, String> ... value) {
            this.featureValues = Arrays.asList(value);
            return this;
        }

        public Builder addFeatureValues(Map<String, String> value) {
            if (this.featureValues == null) {
                this.featureValues = new ArrayList<Map<String, String>>();
            }
            this.featureValues.add(value);
            return this;
        }

        @Override
        public PreviewDataFrameAnalyticsResponse build() {
            return new PreviewDataFrameAnalyticsResponse(this);
        }
    }
}

