/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ModelPlotConfig
implements JsonpSerializable {
    @Nullable
    private final Boolean annotationsEnabled;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final String terms;
    public static final JsonpDeserializer<ModelPlotConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelPlotConfig::setupModelPlotConfigDeserializer, Builder::build);

    public ModelPlotConfig(Builder builder) {
        this.annotationsEnabled = builder.annotationsEnabled;
        this.enabled = builder.enabled;
        this.terms = builder.terms;
    }

    public ModelPlotConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean annotationsEnabled() {
        return this.annotationsEnabled;
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public String terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.annotationsEnabled != null) {
            generator.writeKey("annotations_enabled");
            generator.write(this.annotationsEnabled.booleanValue());
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.terms != null) {
            generator.writeKey("terms");
            generator.write(this.terms);
        }
    }

    protected static void setupModelPlotConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::annotationsEnabled, JsonpDeserializer.booleanDeserializer(), "annotations_enabled", new String[0]);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::terms, JsonpDeserializer.stringDeserializer(), "terms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ModelPlotConfig> {
        @Nullable
        private Boolean annotationsEnabled;
        @Nullable
        private Boolean enabled;
        @Nullable
        private String terms;

        public Builder annotationsEnabled(@Nullable Boolean value) {
            this.annotationsEnabled = value;
            return this;
        }

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder terms(@Nullable String value) {
            this.terms = value;
            return this;
        }

        @Override
        public ModelPlotConfig build() {
            return new ModelPlotConfig(this);
        }
    }
}

