/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.OverallBucket;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetOverallBucketsResponse
implements JsonpSerializable {
    private final long count;
    private final List<OverallBucket> overallBuckets;
    public static final JsonpDeserializer<GetOverallBucketsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetOverallBucketsResponse::setupGetOverallBucketsResponseDeserializer, Builder::build);

    public GetOverallBucketsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.overallBuckets = ModelTypeHelper.unmodifiableNonNull(builder.overallBuckets, "overall_buckets");
    }

    public GetOverallBucketsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<OverallBucket> overallBuckets() {
        return this.overallBuckets;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("overall_buckets");
        generator.writeStartArray();
        for (OverallBucket item0 : this.overallBuckets) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetOverallBucketsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::overallBuckets, JsonpDeserializer.arrayDeserializer(OverallBucket._DESERIALIZER), "overall_buckets", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetOverallBucketsResponse> {
        private Long count;
        private List<OverallBucket> overallBuckets;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder overallBuckets(List<OverallBucket> value) {
            this.overallBuckets = value;
            return this;
        }

        public Builder overallBuckets(OverallBucket ... value) {
            this.overallBuckets = Arrays.asList(value);
            return this;
        }

        public Builder addOverallBuckets(OverallBucket value) {
            if (this.overallBuckets == null) {
                this.overallBuckets = new ArrayList<OverallBucket>();
            }
            this.overallBuckets.add(value);
            return this;
        }

        public Builder overallBuckets(Function<OverallBucket.Builder, ObjectBuilder<OverallBucket>> fn) {
            return this.overallBuckets(fn.apply(new OverallBucket.Builder()).build());
        }

        public Builder addOverallBuckets(Function<OverallBucket.Builder, ObjectBuilder<OverallBucket>> fn) {
            return this.addOverallBuckets(fn.apply(new OverallBucket.Builder()).build());
        }

        @Override
        public GetOverallBucketsResponse build() {
            return new GetOverallBucketsResponse(this);
        }
    }
}

