/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetModelSnapshotsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetModelSnapshotsRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String snapshotId;
    @Nullable
    private final Boolean desc;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final String sort;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    public static final JsonpDeserializer<GetModelSnapshotsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelSnapshotsRequest::setupGetModelSnapshotsRequestDeserializer, Builder::build);
    public static final Endpoint<GetModelSnapshotsRequest, GetModelSnapshotsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetModelSnapshotsRequest, GetModelSnapshotsResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _snapshotId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.snapshotId() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.desc != null) {
            params.put("desc", String.valueOf(request.desc));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.sort != null) {
            params.put("sort", request.sort);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetModelSnapshotsResponse._DESERIALIZER);

    public GetModelSnapshotsRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.snapshotId = builder.snapshotId;
        this.desc = builder.desc;
        this.from = builder.from;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
        this.end = builder.end;
    }

    public GetModelSnapshotsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public Boolean desc() {
        return this.desc;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public String sort() {
        return this.sort;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
    }

    protected static void setupGetModelSnapshotsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start", new String[0]);
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetModelSnapshotsRequest> {
        private String jobId;
        @Nullable
        private String snapshotId;
        @Nullable
        private Boolean desc;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private String sort;
        @Nullable
        private String start;
        @Nullable
        private String end;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder snapshotId(@Nullable String value) {
            this.snapshotId = value;
            return this;
        }

        public Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        @Override
        public GetModelSnapshotsRequest build() {
            return new GetModelSnapshotsRequest(this);
        }
    }
}

