/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDatafeedsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetDatafeedsRequest
extends RequestBase {
    @Nullable
    private final List<String> datafeedId;
    @Nullable
    private final Boolean allowNoDatafeeds;
    @Nullable
    private final Boolean excludeGenerated;
    public static final Endpoint<GetDatafeedsRequest, GetDatafeedsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetDatafeedsRequest, GetDatafeedsResponse>(request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoDatafeeds != null) {
            params.put("allow_no_datafeeds", String.valueOf(request.allowNoDatafeeds));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDatafeedsResponse._DESERIALIZER);

    public GetDatafeedsRequest(Builder builder) {
        this.datafeedId = ModelTypeHelper.unmodifiable(builder.datafeedId);
        this.allowNoDatafeeds = builder.allowNoDatafeeds;
        this.excludeGenerated = builder.excludeGenerated;
    }

    public GetDatafeedsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public Boolean allowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    @Nullable
    public Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    public static class Builder
    implements ObjectBuilder<GetDatafeedsRequest> {
        @Nullable
        private List<String> datafeedId;
        @Nullable
        private Boolean allowNoDatafeeds;
        @Nullable
        private Boolean excludeGenerated;

        public Builder datafeedId(@Nullable List<String> value) {
            this.datafeedId = value;
            return this;
        }

        public Builder datafeedId(String ... value) {
            this.datafeedId = Arrays.asList(value);
            return this;
        }

        public Builder addDatafeedId(String value) {
            if (this.datafeedId == null) {
                this.datafeedId = new ArrayList<String>();
            }
            this.datafeedId.add(value);
            return this;
        }

        public Builder allowNoDatafeeds(@Nullable Boolean value) {
            this.allowNoDatafeeds = value;
            return this;
        }

        public Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        @Override
        public GetDatafeedsRequest build() {
            return new GetDatafeedsRequest(this);
        }
    }
}

