/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Category;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetCategoriesResponse
implements JsonpSerializable {
    private final List<Category> categories;
    private final long count;
    public static final JsonpDeserializer<GetCategoriesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCategoriesResponse::setupGetCategoriesResponseDeserializer, Builder::build);

    public GetCategoriesResponse(Builder builder) {
        this.categories = ModelTypeHelper.unmodifiableNonNull(builder.categories, "categories");
        this.count = Objects.requireNonNull(builder.count, "count");
    }

    public GetCategoriesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Category> categories() {
        return this.categories;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("categories");
        generator.writeStartArray();
        for (Category item0 : this.categories) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("count");
        generator.write(this.count);
    }

    protected static void setupGetCategoriesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::categories, JsonpDeserializer.arrayDeserializer(Category._DESERIALIZER), "categories", new String[0]);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetCategoriesResponse> {
        private List<Category> categories;
        private Long count;

        public Builder categories(List<Category> value) {
            this.categories = value;
            return this;
        }

        public Builder categories(Category ... value) {
            this.categories = Arrays.asList(value);
            return this;
        }

        public Builder addCategories(Category value) {
            if (this.categories == null) {
                this.categories = new ArrayList<Category>();
            }
            this.categories.add(value);
            return this;
        }

        public Builder categories(Function<Category.Builder, ObjectBuilder<Category>> fn) {
            return this.categories(fn.apply(new Category.Builder()).build());
        }

        public Builder addCategories(Function<Category.Builder, ObjectBuilder<Category>> fn) {
            return this.addCategories(fn.apply(new Category.Builder()).build());
        }

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        public GetCategoriesResponse build() {
            return new GetCategoriesResponse(this);
        }
    }
}

