/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Filter
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String filterId;
    private final List<String> items;
    public static final JsonpDeserializer<Filter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Filter::setupFilterDeserializer, Builder::build);

    public Filter(Builder builder) {
        this.description = builder.description;
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
        this.items = ModelTypeHelper.unmodifiableNonNull(builder.items, "items");
    }

    public Filter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public String filterId() {
        return this.filterId;
    }

    public List<String> items() {
        return this.items;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("filter_id");
        generator.write(this.filterId);
        generator.writeKey("items");
        generator.writeStartArray();
        for (String item0 : this.items) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::filterId, JsonpDeserializer.stringDeserializer(), "filter_id", new String[0]);
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "items", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Filter> {
        @Nullable
        private String description;
        private String filterId;
        private List<String> items;

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public Builder items(List<String> value) {
            this.items = value;
            return this;
        }

        public Builder items(String ... value) {
            this.items = Arrays.asList(value);
            return this;
        }

        public Builder addItems(String value) {
            if (this.items == null) {
                this.items = new ArrayList<String>();
            }
            this.items.add(value);
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }
    }
}

