/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.EstimateModelMemoryResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EstimateModelMemoryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AnalysisConfig analysisConfig;
    @Nullable
    private final Map<String, Long> maxBucketCardinality;
    @Nullable
    private final Map<String, Long> overallCardinality;
    public static final JsonpDeserializer<EstimateModelMemoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EstimateModelMemoryRequest::setupEstimateModelMemoryRequestDeserializer, Builder::build);
    public static final Endpoint<EstimateModelMemoryRequest, EstimateModelMemoryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<EstimateModelMemoryRequest, EstimateModelMemoryResponse>(request -> "POST", request -> "/_ml/anomaly_detectors/_estimate_model_memory", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, EstimateModelMemoryResponse._DESERIALIZER);

    public EstimateModelMemoryRequest(Builder builder) {
        this.analysisConfig = builder.analysisConfig;
        this.maxBucketCardinality = ModelTypeHelper.unmodifiable(builder.maxBucketCardinality);
        this.overallCardinality = ModelTypeHelper.unmodifiable(builder.overallCardinality);
    }

    public EstimateModelMemoryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    @Nullable
    public Map<String, Long> maxBucketCardinality() {
        return this.maxBucketCardinality;
    }

    @Nullable
    public Map<String, Long> overallCardinality() {
        return this.overallCardinality;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysisConfig != null) {
            generator.writeKey("analysis_config");
            this.analysisConfig.serialize(generator, mapper);
        }
        if (this.maxBucketCardinality != null) {
            generator.writeKey("max_bucket_cardinality");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.maxBucketCardinality.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        if (this.overallCardinality != null) {
            generator.writeKey("overall_cardinality");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.overallCardinality.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupEstimateModelMemoryRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config", new String[0]);
        op.add(Builder::maxBucketCardinality, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "max_bucket_cardinality", new String[0]);
        op.add(Builder::overallCardinality, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "overall_cardinality", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EstimateModelMemoryRequest> {
        @Nullable
        private AnalysisConfig analysisConfig;
        @Nullable
        private Map<String, Long> maxBucketCardinality;
        @Nullable
        private Map<String, Long> overallCardinality;

        public Builder analysisConfig(@Nullable AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public Builder maxBucketCardinality(@Nullable Map<String, Long> value) {
            this.maxBucketCardinality = value;
            return this;
        }

        public Builder putMaxBucketCardinality(String key, Long value) {
            if (this.maxBucketCardinality == null) {
                this.maxBucketCardinality = new HashMap<String, Long>();
            }
            this.maxBucketCardinality.put(key, value);
            return this;
        }

        public Builder overallCardinality(@Nullable Map<String, Long> value) {
            this.overallCardinality = value;
            return this;
        }

        public Builder putOverallCardinality(String key, Long value) {
            if (this.overallCardinality == null) {
                this.overallCardinality = new HashMap<String, Long>();
            }
            this.overallCardinality.put(key, value);
            return this;
        }

        @Override
        public EstimateModelMemoryRequest build() {
            return new EstimateModelMemoryRequest(this);
        }
    }
}

