/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.FilterRef;
import co.elastic.clients.elasticsearch.ml.RuleAction;
import co.elastic.clients.elasticsearch.ml.RuleCondition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DetectionRule
implements JsonpSerializable {
    @Nullable
    private final List<RuleAction> actions;
    @Nullable
    private final List<RuleCondition> conditions;
    @Nullable
    private final Map<String, FilterRef> scope;
    public static final JsonpDeserializer<DetectionRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DetectionRule::setupDetectionRuleDeserializer, Builder::build);

    public DetectionRule(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
        this.conditions = ModelTypeHelper.unmodifiable(builder.conditions);
        this.scope = ModelTypeHelper.unmodifiable(builder.scope);
    }

    public DetectionRule(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<RuleAction> actions() {
        return this.actions;
    }

    @Nullable
    public List<RuleCondition> conditions() {
        return this.conditions;
    }

    @Nullable
    public Map<String, FilterRef> scope() {
        return this.scope;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actions != null) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (RuleAction ruleAction : this.actions) {
                ruleAction.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.conditions != null) {
            generator.writeKey("conditions");
            generator.writeStartArray();
            for (RuleCondition ruleCondition : this.conditions) {
                ruleCondition.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scope != null) {
            generator.writeKey("scope");
            generator.writeStartObject();
            for (Map.Entry entry : this.scope.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((FilterRef)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDetectionRuleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(RuleAction._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::conditions, JsonpDeserializer.arrayDeserializer(RuleCondition._DESERIALIZER), "conditions", new String[0]);
        op.add(Builder::scope, JsonpDeserializer.stringMapDeserializer(FilterRef._DESERIALIZER), "scope", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DetectionRule> {
        @Nullable
        private List<RuleAction> actions;
        @Nullable
        private List<RuleCondition> conditions;
        @Nullable
        private Map<String, FilterRef> scope;

        public Builder actions(@Nullable List<RuleAction> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(RuleAction ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(RuleAction value) {
            if (this.actions == null) {
                this.actions = new ArrayList<RuleAction>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder conditions(@Nullable List<RuleCondition> value) {
            this.conditions = value;
            return this;
        }

        public Builder conditions(RuleCondition ... value) {
            this.conditions = Arrays.asList(value);
            return this;
        }

        public Builder addConditions(RuleCondition value) {
            if (this.conditions == null) {
                this.conditions = new ArrayList<RuleCondition>();
            }
            this.conditions.add(value);
            return this;
        }

        public Builder conditions(Function<RuleCondition.Builder, ObjectBuilder<RuleCondition>> fn) {
            return this.conditions(fn.apply(new RuleCondition.Builder()).build());
        }

        public Builder addConditions(Function<RuleCondition.Builder, ObjectBuilder<RuleCondition>> fn) {
            return this.addConditions(fn.apply(new RuleCondition.Builder()).build());
        }

        public Builder scope(@Nullable Map<String, FilterRef> value) {
            this.scope = value;
            return this;
        }

        public Builder putScope(String key, FilterRef value) {
            if (this.scope == null) {
                this.scope = new HashMap<String, FilterRef>();
            }
            this.scope.put(key, value);
            return this;
        }

        public Builder scope(String key, Function<FilterRef.Builder, ObjectBuilder<FilterRef>> fn) {
            return this.scope(Collections.singletonMap(key, fn.apply(new FilterRef.Builder()).build()));
        }

        public Builder putScope(String key, Function<FilterRef.Builder, ObjectBuilder<FilterRef>> fn) {
            return this.putScope(key, fn.apply(new FilterRef.Builder()).build());
        }

        @Override
        public DetectionRule build() {
            return new DetectionRule(this);
        }
    }
}

