/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteDatafeedResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteDatafeedRequest
extends RequestBase {
    private final String datafeedId;
    @Nullable
    private final Boolean force;
    public static final Endpoint<DeleteDatafeedRequest, DeleteDatafeedResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteDatafeedRequest, DeleteDatafeedResponse>(request -> "DELETE", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteDatafeedResponse._DESERIALIZER);

    public DeleteDatafeedRequest(Builder builder) {
        this.datafeedId = Objects.requireNonNull(builder.datafeedId, "datafeed_id");
        this.force = builder.force;
    }

    public DeleteDatafeedRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    public static class Builder
    implements ObjectBuilder<DeleteDatafeedRequest> {
        private String datafeedId;
        @Nullable
        private Boolean force;

        public Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        @Override
        public DeleteDatafeedRequest build() {
            return new DeleteDatafeedRequest(this);
        }
    }
}

