/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DeleteCalendarJobResponse
implements JsonpSerializable {
    private final String calendarId;
    @Nullable
    private final String description;
    private final List<String> jobIds;
    public static final JsonpDeserializer<DeleteCalendarJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteCalendarJobResponse::setupDeleteCalendarJobResponseDeserializer, Builder::build);

    public DeleteCalendarJobResponse(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
        this.description = builder.description;
        this.jobIds = ModelTypeHelper.unmodifiableNonNull(builder.jobIds, "job_ids");
    }

    public DeleteCalendarJobResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public List<String> jobIds() {
        return this.jobIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("calendar_id");
        generator.write(this.calendarId);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("job_ids");
        generator.writeStartArray();
        for (String item0 : this.jobIds) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupDeleteCalendarJobResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::calendarId, JsonpDeserializer.stringDeserializer(), "calendar_id", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::jobIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "job_ids", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DeleteCalendarJobResponse> {
        private String calendarId;
        @Nullable
        private String description;
        private List<String> jobIds;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder jobIds(List<String> value) {
            this.jobIds = value;
            return this;
        }

        public Builder jobIds(String ... value) {
            this.jobIds = Arrays.asList(value);
            return this;
        }

        public Builder addJobIds(String value) {
            if (this.jobIds == null) {
                this.jobIds = new ArrayList<String>();
            }
            this.jobIds.add(value);
            return this;
        }

        @Override
        public DeleteCalendarJobResponse build() {
            return new DeleteCalendarJobResponse(this);
        }
    }
}

